/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class DistillationRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final float[] chances;
    public final FluidStack[] fluidOutput;
    public final ItemStack[] itemOutput;
    public final FluidStack input;
    public static ArrayList<DistillationRecipe> recipeList = new ArrayList();
    int totalProcessTime;
    int totalProcessEnergy;

    public DistillationRecipe(FluidStack[] fluidOutput, ItemStack[] itemOutput, FluidStack input, int energy, int time, float[] chances) {
        this.fluidOutput = fluidOutput;
        this.itemOutput = itemOutput;
        this.input = input;
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor((float)time * timeModifier);
        this.chances = chances;
        this.fluidInputList = Collections.singletonList(this.input);
        this.fluidOutputList = Arrays.asList(this.fluidOutput);
        this.outputList = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])itemOutput);
    }

    public static DistillationRecipe addRecipe(FluidStack[] fluidOutputs, ItemStack[] itemOutputs, FluidStack input, int energy, int time, float[] chances) {
        DistillationRecipe r = new DistillationRecipe(fluidOutputs, itemOutputs, input, energy, time, chances);
        recipeList.add(r);
        return r;
    }

    public static DistillationRecipe findRecipe(FluidStack input) {
        for (DistillationRecipe recipe : recipeList) {
            if (input == null || recipe.input == null || !input.containsFluid(recipe.input)) continue;
            return recipe;
        }
        return null;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static DistillationRecipe loadFromNBT(NBTTagCompound nbt) {
        FluidStack input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("input"));
        return DistillationRecipe.findRecipe(input);
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }

    public NonNullList<ItemStack> getActualItemOutputs(TileEntity tile) {
        NonNullList output = NonNullList.func_191196_a();
        for (int i = 0; i < this.itemOutput.length; ++i) {
            if (!(tile.func_145831_w().field_73012_v.nextFloat() <= this.chances[i])) continue;
            output.add((Object)this.itemOutput[i]);
        }
        return output;
    }
}

