/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.jaff.entities;

import com.tmtravlr.jaff.JAFFMod;
import com.tmtravlr.jaff.entities.EntityFish;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityFishPufferfish
extends EntityFish {
    private static final ResourceLocation ADULT_TEXTURE = new ResourceLocation("jaff:textures/entity/fish_pufferfish.png");
    private static final ResourceLocation BABY_TEXTURE = new ResourceLocation("jaff:textures/entity/fish_pufferfish_baby.png");
    public float puffedXScale = 2.7f;
    public float puffedYScale = 1.5f;
    public float puffedZScale = 1.0f;
    public float puffedAmount = 0.0f;
    public int scaredTime = 0;

    public EntityFishPufferfish(World world) {
        super(world);
        this.setBaitTypes("seeds", "worms");
    }

    @Override
    public float getBaseScale() {
        return 0.7f;
    }

    @Override
    public int getStrain() {
        return 20;
    }

    @Override
    public EntityFish createChild(EntityAgeable entity) {
        return new EntityFishPufferfish(this.field_70170_p);
    }

    protected ResourceLocation func_184647_J() {
        return JAFFMod.LOOT_ENTITIES_PUFFERFISH;
    }

    @Override
    public ResourceLocation getTextureLocationBaby() {
        return BABY_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureLocationAdult() {
        return ADULT_TEXTURE;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
    }

    @Override
    public float getScaleX() {
        return super.getScaleX() * (1.0f + this.puffedAmount * ((this.func_70090_H() || this.func_180799_ab() ? this.puffedXScale : this.puffedYScale) - 1.0f));
    }

    @Override
    public float getScaleY() {
        return super.getScaleY() * (1.0f + this.puffedAmount * ((this.func_70090_H() || this.func_180799_ab() ? this.puffedYScale : this.puffedXScale) - 1.0f));
    }

    @Override
    public float getScaleZ() {
        return super.getScaleZ() * (1.0f + this.puffedAmount * (this.puffedZScale - 1.0f));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(2000) == 0) {
                this.scaredTime += 100;
            }
            if (this.scaredTime > 0) {
                --this.scaredTime;
            }
            if (this.scaredTime > 0 && this.puffedAmount < 0.95f) {
                this.puffedAmount = (this.puffedAmount * 7.0f + 1.0f) / 8.0f;
            } else if (this.scaredTime <= 0 && this.puffedAmount > 0.05f) {
                this.puffedAmount = (this.puffedAmount * 7.0f + 0.0f) / 8.0f;
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.scaredTime = 200;
        return super.func_70097_a(source, amount);
    }

    @Override
    public NBTTagCompound func_189511_e(NBTTagCompound tag) {
        super.func_189511_e(tag);
        tag.func_74776_a("PuffedAmount", this.puffedAmount);
        tag.func_74768_a("ScaredTime", this.scaredTime);
        return tag;
    }

    @Override
    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.puffedAmount = tag.func_74760_g("PuffedAmount");
        this.scaredTime = tag.func_74762_e("ScaredTime");
    }
}

