/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.network;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.config.DimensionConfigEntry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.client.FMLClientHandler;

public class DimensionSyncPacket {
    private ByteBuf buffer = Unpooled.buffer();
    private List<DimensionConfigEntry> dimensions = new ArrayList<DimensionConfigEntry>();

    public void addDimensionData(Collection<DimensionConfigEntry> entries) {
        this.buffer.writeInt(entries.size());
        for (DimensionConfigEntry entry : entries) {
            entry.writeToByteBuf(this.buffer);
        }
    }

    public void consumePacket(ByteBuf buf) {
        int count = buf.readInt();
        this.dimensions.clear();
        for (int i = 0; i < count; ++i) {
            DimensionConfigEntry entry = DimensionConfigEntry.fromByteBuf(buf);
            if (entry == null) continue;
            this.dimensions.add(entry);
        }
    }

    public ByteBuf getData() {
        return this.buffer;
    }

    public void execute() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc == null) {
            JustEnoughDimensions.logger.error("Minecraft was null in DimensionSyncPacket");
            return;
        }
        mc.func_152344_a(new Runnable(){

            @Override
            public void run() {
                DimensionSyncPacket.this.processMessage();
            }
        });
    }

    protected void processMessage() {
        String str = DimensionSyncPacket.registerDimensions(this.dimensions);
        JustEnoughDimensions.logInfo("DimensionSyncPacket: Registered dimensions: '" + str + "'", new Object[0]);
    }

    public static String registerDimensions(List<DimensionConfigEntry> dimensions) {
        ArrayList<String> ids = new ArrayList<String>();
        for (DimensionConfigEntry entry : dimensions) {
            DimensionSyncPacket.registerDimension(entry.getDimension(), entry);
            if (entry.getUnregister() || !entry.hasDimensionTypeEntry()) continue;
            ids.add(String.valueOf(entry.getDimension()));
        }
        return String.join((CharSequence)", ", ids);
    }

    private static void registerDimension(int dimension, DimensionConfigEntry entry) {
        DimensionType type;
        if (entry.getUnregister() || !entry.hasDimensionTypeEntry()) {
            return;
        }
        if (DimensionManager.isDimensionRegistered((int)dimension) && (type = DimensionManager.getProviderType((int)dimension)).func_186070_d().getClass() != entry.getDimensionTypeEntry().getProviderClass()) {
            JustEnoughDimensions.logInfo("DimensionSyncPacket.registerDimension: Dimension {} already registered, unregistering the old one", dimension);
            DimensionManager.unregisterDimension((int)dimension);
        }
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            JustEnoughDimensions.logInfo("DimensionSyncPacket.registerDimension: Registering dimension {}", dimension);
            DimensionManager.registerDimension((int)dimension, (DimensionType)entry.getDimensionTypeEntry().getOrRegisterDimensionType(dimension));
        }
    }
}

