/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.stronghold;

import java.util.List;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.structures.stronghold.ComponentTFStrongholdAccessChamber;
import twilightforest.structures.stronghold.ComponentTFStrongholdBossRoom;
import twilightforest.structures.stronghold.ComponentTFStrongholdDeadEnd;
import twilightforest.structures.stronghold.ComponentTFStrongholdSmallStairs;
import twilightforest.structures.stronghold.ComponentTFStrongholdTreasureCorridor;
import twilightforest.structures.stronghold.ComponentTFStrongholdTreasureRoom;
import twilightforest.structures.stronghold.StructureTFDecoratorStronghold;
import twilightforest.structures.stronghold.StructureTFStrongholdComponent;
import twilightforest.structures.stronghold.TFStrongholdPieces;

public class ComponentTFStrongholdEntrance
extends StructureTFStrongholdComponent {
    public TFStrongholdPieces lowerPieces;

    public ComponentTFStrongholdEntrance() {
    }

    public ComponentTFStrongholdEntrance(TFFeature feature, World world, Random rand, int i, int x, int y, int z) {
        super(feature, i, EnumFacing.SOUTH, x, y - 10, z);
        this.deco = new StructureTFDecoratorStronghold();
        this.lowerPieces = new TFStrongholdPieces();
    }

    @Override
    public void func_74861_a(StructureComponent parent, List<StructureComponent> list, Random random) {
        super.func_74861_a(parent, list, random);
        this.lowerPieces.prepareStructurePieces();
        this.addNewComponent(parent, list, random, Rotation.NONE, 4, 1, 18);
        this.lowerPieces.prepareStructurePieces();
        if (this.listContainsBossRoom(list)) {
            this.lowerPieces.markBossRoomUsed();
        }
        this.addNewComponent(parent, list, random, Rotation.CLOCKWISE_90, -1, 1, 13);
        this.lowerPieces.prepareStructurePieces();
        if (this.listContainsBossRoom(list)) {
            this.lowerPieces.markBossRoomUsed();
        }
        this.addNewComponent(parent, list, random, Rotation.CLOCKWISE_180, 13, 1, -1);
        this.lowerPieces.prepareStructurePieces();
        if (this.listContainsBossRoom(list)) {
            this.lowerPieces.markBossRoomUsed();
        }
        this.addNewComponent(parent, list, random, Rotation.COUNTERCLOCKWISE_90, 18, 1, 4);
        if (!this.listContainsBossRoom(list)) {
            TwilightForestMod.LOGGER.warn("Did not find boss room from exit 3 - EPIC FAIL");
        }
        StructureBoundingBox shieldBox = new StructureBoundingBox(this.field_74887_e);
        int tStairs = 0;
        int tCorridors = 0;
        int deadEnd = 0;
        int tRooms = 0;
        int bossRooms = 0;
        for (StructureComponent component : list) {
            shieldBox.func_78888_b(component.func_74874_b());
            if (component instanceof ComponentTFStrongholdSmallStairs && ((ComponentTFStrongholdSmallStairs)component).hasTreasure) {
                ++tStairs;
            }
            if (component instanceof ComponentTFStrongholdTreasureCorridor) {
                ++tCorridors;
            }
            if (component instanceof ComponentTFStrongholdDeadEnd) {
                ++deadEnd;
            }
            if (component instanceof ComponentTFStrongholdTreasureRoom) {
                ++tRooms;
            }
            if (!(component instanceof ComponentTFStrongholdBossRoom)) continue;
            ++bossRooms;
        }
        ComponentTFStrongholdAccessChamber accessChamber = new ComponentTFStrongholdAccessChamber(this.getFeatureType(), 2, this.func_186165_e(), this.field_74887_e.field_78897_a + 8, this.field_74887_e.field_78895_b + 7, this.field_74887_e.field_78896_c + 4);
        list.add(accessChamber);
        ((StructureTFStrongholdComponent)accessChamber).func_74861_a(this, list, random);
    }

    private boolean listContainsBossRoom(List<StructureComponent> list) {
        for (StructureComponent component : list) {
            if (!(component instanceof ComponentTFStrongholdBossRoom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StructureBoundingBox generateBoundingBox(EnumFacing facing, int x, int y, int z) {
        return StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)18, (int)7, (int)18, (EnumFacing)facing);
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        this.placeStrongholdWalls(world, sbb, 0, 0, 0, 17, 6, 17, rand, this.deco.randomBlocks);
        this.placeCornerStatue(world, 5, 1, 5, 0, sbb);
        this.placeCornerStatue(world, 5, 1, 12, 1, sbb);
        this.placeCornerStatue(world, 12, 1, 5, 2, sbb);
        this.placeCornerStatue(world, 12, 1, 12, 3, sbb);
        this.placeWallStatue(world, 9, 1, 16, Rotation.NONE, sbb);
        this.placeWallStatue(world, 1, 1, 9, Rotation.CLOCKWISE_90, sbb);
        this.placeWallStatue(world, 8, 1, 1, Rotation.CLOCKWISE_180, sbb);
        this.placeWallStatue(world, 16, 1, 8, Rotation.COUNTERCLOCKWISE_90, sbb);
        this.placeDoors(world, rand, sbb);
        return true;
    }
}

