/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;

public class EntityUtils {
    public static void removeAI(EntityLiving entity, Class<? extends EntityAIBase> clazz) {
        entity.field_70714_bg.field_75782_a.removeIf(entityAITaskEntry -> clazz.isAssignableFrom(entityAITaskEntry.field_75733_a.getClass()));
    }

    public static boolean hasAI(EntityLiving entity, Class<? extends EntityAIBase> clazz) {
        return entity.field_70714_bg.field_75782_a.stream().anyMatch(entityAITaskEntry -> clazz.isAssignableFrom(entityAITaskEntry.field_75733_a.getClass()));
    }

    public static <T extends EntityAIBase> Optional<T> findFirst(EntityLiving entity, Class<? extends EntityAIBase> clazz) {
        return entity.field_70714_bg.field_75782_a.stream().filter(t -> clazz.isAssignableFrom(t.getClass())).map(t -> t.field_75733_a).findFirst();
    }

    public static void copyEntityInfo(EntityLivingBase copyFrom, EntityLivingBase copyTo) {
        copyTo.func_70606_j(copyFrom.func_110143_aJ());
        copyTo.func_70080_a(copyFrom.field_70165_t, copyFrom.field_70163_u, copyFrom.field_70161_v, copyFrom.field_70177_z, copyFrom.field_70125_A);
        copyTo.func_70034_d(copyFrom.func_70079_am());
    }

    private static Class entityFromID(String id) {
        return EntityList.func_192839_a((String)id);
    }

    private static Class entityFromClassName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }

    public static List<Class> loadEntitiesFromStrings(String[] strings) {
        ArrayList entities = Lists.newArrayList();
        for (String string : strings) {
            if (string.contains(":")) {
                entities.add(EntityUtils.entityFromID(string));
                continue;
            }
            entities.add(EntityUtils.entityFromClassName(string));
        }
        return entities;
    }
}

