/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.creatures;

import betterwithmods.common.items.ItemArcaneScroll;
import betterwithmods.module.Feature;
import betterwithmods.util.InfernalEnchantment;
import betterwithmods.util.InvUtils;
import betterwithmods.util.WorldUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DimensionType;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class HCEnchanting
extends Feature {
    private static final HashMap<Class<? extends EntityLivingBase>, ScrollDrop> SCROLL_DROPS = Maps.newHashMap();
    private static Map<Enchantment, Integer> LEVEL_OVERRIDE = Maps.newHashMap();
    private static double dropChance;
    private static double lootingDropBonus;
    private static boolean fuckMending;
    private static boolean steelRequiresInfernal;

    public static void addEnchantOverride(Enchantment enchantment, int max) {
        LEVEL_OVERRIDE.put(enchantment, max);
    }

    public static int getMaxLevel(Enchantment enchantment) {
        return LEVEL_OVERRIDE.getOrDefault(enchantment, enchantment.func_77325_b());
    }

    public static boolean canEnchantSteel(Enchantment enchantment) {
        return !steelRequiresInfernal || enchantment instanceof InfernalEnchantment;
    }

    public static void addScrollDrop(Class<? extends EntityLivingBase> clazz, Enchantment enchantment) {
        HCEnchanting.addScrollDrop(clazz, (EntityLivingBase entity) -> ItemArcaneScroll.getScrollWithEnchant(enchantment));
    }

    public static void addScrollDrop(Class<? extends EntityLivingBase> clazz, ItemStack scroll) {
        HCEnchanting.addScrollDrop(clazz, (EntityLivingBase entity) -> scroll);
    }

    public static void addScrollDrop(Class<? extends EntityLivingBase> clazz, ScrollDrop scroll) {
        SCROLL_DROPS.put(clazz, scroll);
    }

    @Override
    public void setupConfig() {
        steelRequiresInfernal = this.loadPropBool("Steel Requires Infernal Enchanter", "Soulforged Steel tools can only be enchanted with the Infernal Enchanter", true);
        dropChance = this.loadPropDouble("Arcane Scroll Drop Chance", "Percentage chance that an arcane scroll will drop, does not effect some scrolls.", 0.001);
        lootingDropBonus = this.loadPropDouble("Arcane Scroll Looting Bonu Multiplier", "Increase the chance of getting a scroll with looting enchants baseChance + (lootingDropBonus * lootingLevel)", 0.1);
        fuckMending = this.loadPropBool("Disable Mending", "Mending is a bad unbalanced pile of poo", true);
    }

    @Override
    public String getFeatureDescription() {
        return "Adds Arcane Scroll drops to specific mobs, used for enchanting with the Infernal Enchanter";
    }

    @Override
    public void init(FMLInitializationEvent event) {
        HCEnchanting.addScrollDrop(EntitySlime.class, Enchantments.field_180310_c);
        HCEnchanting.addScrollDrop(EntityPigZombie.class, Enchantments.field_77329_d);
        HCEnchanting.addScrollDrop(EntityBat.class, Enchantments.field_180309_e);
        HCEnchanting.addScrollDrop(EntityCreeper.class, Enchantments.field_185297_d);
        HCEnchanting.addScrollDrop(AbstractSkeleton.class, (EntityLivingBase entity) -> {
            if (entity.field_70170_p.field_73011_w.func_186058_p() == DimensionType.NETHER) {
                return ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_185312_x);
            }
            return ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_180308_g);
        });
        HCEnchanting.addScrollDrop(EntitySquid.class, Enchantments.field_185298_f);
        HCEnchanting.addScrollDrop(EntityWitch.class, Enchantments.field_185299_g);
        HCEnchanting.addScrollDrop(EntityZombie.class, Enchantments.field_185303_l);
        HCEnchanting.addScrollDrop(EntitySpider.class, Enchantments.field_180312_n);
        HCEnchanting.addScrollDrop(EntityMagmaCube.class, Enchantments.field_77334_n);
        HCEnchanting.addScrollDrop(EntityEnderman.class, Enchantments.field_185306_r);
        HCEnchanting.addScrollDrop(EntityGhast.class, Enchantments.field_185310_v);
        HCEnchanting.addScrollDrop(EntityBlaze.class, Enchantments.field_185311_w);
        HCEnchanting.addScrollDrop(EntityPolarBear.class, Enchantments.field_185301_j);
        HCEnchanting.addScrollDrop(EntityGuardian.class, Enchantments.field_185300_i);
        if (!fuckMending) {
            HCEnchanting.addScrollDrop(EntityShulker.class, new ScrollDrop(){

                @Override
                public ItemStack getScroll(EntityLivingBase entity) {
                    return ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_185296_A);
                }

                @Override
                public double getChance() {
                    return 0.001;
                }
            });
        }
        HCEnchanting.addScrollDrop(EntityDragon.class, new ScrollDrop(){

            @Override
            public ItemStack getScroll(EntityLivingBase entity) {
                return ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_191530_r);
            }

            @Override
            public double getChance() {
                return 1.0;
            }
        });
        HCEnchanting.addScrollDrop(EntityWither.class, new ScrollDrop(){

            @Override
            public ItemStack getScroll(EntityLivingBase entity) {
                return ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_180313_o);
            }

            @Override
            public double getChance() {
                return 1.0;
            }
        });
        HCEnchanting.addScrollDrop(EntitySilverfish.class, (EntityLivingBase entity) -> {
            if (entity.field_70170_p.field_73011_w.func_186058_p() == DimensionType.THE_END) {
                return ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_185305_q);
            }
            return null;
        });
        HCEnchanting.addEnchantOverride(Enchantments.field_185298_f, 5);
        PricedTradeList sharpness = new PricedTradeList(new ItemStack(Items.field_151166_bC), new EntityVillager.PriceInfo(35, 50), ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_185302_k));
        PricedTradeList looting = new PricedTradeList(new ItemStack(Items.field_151166_bC), new EntityVillager.PriceInfo(15, 30), ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_185304_p));
        PricedTradeList unbreaking = new PricedTradeList(new ItemStack(Items.field_151166_bC), new EntityVillager.PriceInfo(34, 47), ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_185307_s));
        PricedTradeList efficiency = new PricedTradeList(new ItemStack(Items.field_151166_bC), new EntityVillager.PriceInfo(34, 63), ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_185305_q));
        PricedTradeList fortune = new PricedTradeList(new ItemStack(Items.field_151166_bC), new EntityVillager.PriceInfo(48, 62), ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_185308_t));
        PricedTradeList power = new PricedTradeList(new ItemStack(Items.field_151166_bC), new EntityVillager.PriceInfo(32, 40), ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_185309_u));
        PricedTradeList luckofsea = new PricedTradeList(new ItemStack(Items.field_151166_bC), new EntityVillager.PriceInfo(15, 30), ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_151370_z));
        PricedTradeList lure = new PricedTradeList(new ItemStack(Items.field_151166_bC), new EntityVillager.PriceInfo(10, 20), ItemArcaneScroll.getScrollWithEnchant(Enchantments.field_151370_z));
        HCEnchanting.addVillagerTrade("minecraft:butcher", 0, 5, sharpness);
        HCEnchanting.addVillagerTrade("minecraft:farmer", 0, 5, looting);
        HCEnchanting.addVillagerTrade("minecraft:smith", 2, 5, unbreaking);
        HCEnchanting.addVillagerTrade("minecraft:smith", 2, 5, efficiency);
        HCEnchanting.addVillagerTrade("minecraft:priest", 0, 5, fortune);
        HCEnchanting.addVillagerTrade("minecraft:librarian", 0, 5, power);
        HCEnchanting.addVillagerTrade("minecraft:farmer", 1, 5, luckofsea);
        HCEnchanting.addVillagerTrade("minecraft:farmer", 1, 5, lure);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void onDeath(LivingDropsEvent event) {
        for (Class<? extends EntityLivingBase> entity : SCROLL_DROPS.keySet()) {
            double chance;
            ScrollDrop drop;
            if (!entity.isAssignableFrom(event.getEntityLiving().getClass()) || (drop = SCROLL_DROPS.get(entity)).getScroll(event.getEntityLiving()) == null || !((chance = event.getEntityLiving().func_70681_au().nextDouble() + lootingDropBonus * (double)event.getLootingLevel()) <= drop.getChance())) continue;
            WorldUtils.addDrop(event, drop.getScroll(event.getEntityLiving()));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        int mod;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!event.player.func_130014_f_().field_72995_K && (mod = EnchantmentHelper.func_185292_c((EntityLivingBase)event.player)) >= 5) {
            event.player.func_70050_g(300);
        }
    }

    public static void addVillagerTrade(String profession, int careerId, int level, EntityVillager.ITradeList trade) {
        VillagerRegistry.VillagerProfession profression = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation(profession));
        if (profression != null) {
            VillagerRegistry.VillagerCareer career = profression.getCareer(careerId);
            career.addTrade(level, new EntityVillager.ITradeList[]{trade});
        }
    }

    public static class PricedTradeList
    implements EntityVillager.ITradeList {
        @Nonnull
        private ItemStack input;
        @Nonnull
        private EntityVillager.PriceInfo info;
        @Nonnull
        private ItemStack output;

        public PricedTradeList(@Nonnull ItemStack input, @Nonnull EntityVillager.PriceInfo info, @Nonnull ItemStack output) {
            this.input = input;
            this.info = info;
            this.output = output;
        }

        private ItemStack getInput(Random random) {
            ItemStack copy = this.input.func_77946_l();
            InvUtils.setCount(copy, this.info.func_179412_a(random));
            return copy;
        }

        public void func_190888_a(@Nonnull IMerchant merchant, @Nonnull MerchantRecipeList recipeList, @Nonnull Random random) {
            recipeList.add((Object)new MerchantRecipe(this.getInput(random), this.output));
        }
    }

    public static class TradeList
    implements EntityVillager.ITradeList {
        private List<MerchantRecipe> recipes;

        public TradeList(MerchantRecipe ... recipes) {
            this.recipes = Lists.newArrayList((Object[])recipes);
        }

        public void func_190888_a(@Nonnull IMerchant merchant, @Nonnull MerchantRecipeList recipeList, @Nonnull Random random) {
            recipeList.addAll(this.recipes);
        }
    }

    @FunctionalInterface
    public static interface ScrollDrop {
        public ItemStack getScroll(EntityLivingBase var1);

        default public double getChance() {
            return dropChance;
        }
    }
}

