/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.beacons;

import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.module.ConfigHelper;
import betterwithmods.util.InvUtils;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BeaconEffect {
    protected boolean enabled;
    protected ResourceLocation resourceLocation;
    protected BlockIngredient structureBlock;
    protected Class<? extends EntityLivingBase> validEntityType;
    protected float[] baseBeamColor;
    protected int[] effectRanges;
    protected SoundEvent activationSound;
    protected SoundEvent deactivationSound;
    protected int tickRate;

    public BeaconEffect(String name, BlockIngredient structureBlock, Class<? extends EntityLivingBase> validEntityType) {
        this.resourceLocation = new ResourceLocation("betterwithmods", name + "_beacon");
        this.structureBlock = structureBlock;
        this.validEntityType = validEntityType;
        this.enabled = true;
        this.effectRanges = new int[]{20, 40, 80, 160};
        this.setBaseBeamColor(Color.white);
        this.setActivationSound(SoundEvents.field_187855_gD);
        this.setDeactivationSound(SoundEvents.field_187849_gA);
        this.setTickRate(120);
    }

    public void setupConfig(String categoryName) {
        this.setEnabled(ConfigHelper.loadPropBool("enabled", categoryName, "", true));
        if (this.effectRanges != null) {
            this.setEffectRanges(ConfigHelper.loadPropIntList("effectRanges", categoryName, "Range, in blocks, that the beacon will have an effect", this.effectRanges));
            this.setTickRate(ConfigHelper.loadPropInt("tickRate", categoryName, "The rate, in ticks, that the beacon will update and apply its effect.", this.tickRate));
        }
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public BeaconEffect setBaseBeamColor(Color baseBeamColor) {
        this.baseBeamColor = new float[]{baseBeamColor.getRed() / 255, baseBeamColor.getGreen() / 255, baseBeamColor.getBlue() / 255};
        return this;
    }

    public BeaconEffect setBaseBeamColor(float[] baseBeamColor) {
        this.baseBeamColor = baseBeamColor;
        return this;
    }

    public SoundEvent getDeactivationSound() {
        return this.deactivationSound;
    }

    public BeaconEffect setDeactivationSound(SoundEvent deactivationSound) {
        this.deactivationSound = deactivationSound;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BeaconEffect setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public int[] getEffectRanges() {
        return this.effectRanges;
    }

    public BeaconEffect setEffectRanges(int[] effectRanges) {
        this.effectRanges = effectRanges;
        return this;
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public BeaconEffect setTickRate(int tickRate) {
        this.tickRate = tickRate;
        return this;
    }

    public SoundEvent getActivationSound() {
        return this.activationSound;
    }

    public BeaconEffect setActivationSound(SoundEvent activationSound) {
        this.activationSound = activationSound;
        return this;
    }

    public BlockIngredient getStructureBlock() {
        return this.structureBlock;
    }

    public Class<? extends EntityLivingBase> getValidEntityType() {
        return this.validEntityType;
    }

    public float[] getBaseBeaconBeamColor(BlockPos beaconPos) {
        return this.baseBeamColor;
    }

    public boolean isBlockStateValid(World world, BlockPos pos, IBlockState blockState) {
        return this.structureBlock.apply(world, pos, blockState);
    }

    public NonNullList<EntityLivingBase> getEntitiesInRange(World world, BlockPos pos, int beaconLevel) {
        int radius = this.effectRanges[Math.min(beaconLevel - 1, 3)];
        AxisAlignedBB box = new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_186662_g((double)radius);
        return InvUtils.asNonnullList(world.func_72872_a(this.getValidEntityType(), box));
    }

    public abstract void onBeaconCreate(@Nonnull World var1, @Nonnull BlockPos var2, int var3);

    public abstract void apply(NonNullList<EntityLivingBase> var1, @Nonnull World var2, @Nonnull BlockPos var3, int var4);

    public abstract boolean onPlayerInteracted(World var1, BlockPos var2, int var3, EntityPlayer var4, EnumHand var5, ItemStack var6);

    public abstract void onBeaconBreak(World var1, BlockPos var2, int var3);
}

