/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks.tiles;

import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockMini;
import betterwithmods.module.gameplay.miniblocks.orientations.BaseOrientation;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public abstract class TileMini
extends TileBasic {
    public IBlockState state;
    public BaseOrientation orientation;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = super.func_189515_b(compound);
        if (this.state != null) {
            NBTTagCompound texture = new NBTTagCompound();
            NBTUtil.func_190009_a((NBTTagCompound)texture, (IBlockState)this.state);
            tag.func_74782_a("texture", (NBTBase)texture);
        } else {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        if (this.orientation != null) {
            tag.func_74768_a("orientation", this.orientation.ordinal());
        } else {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        return tag;
    }

    public abstract BaseOrientation deserializeOrientation(NBTTagCompound var1);

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("texture")) {
            this.state = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("texture"));
        } else {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        this.orientation = this.deserializeOrientation(compound);
        super.func_145839_a(compound);
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, @Nullable EnumFacing face, ItemStack stack, float hitX, float hitY, float hitZ) {
        this.loadFromStack(stack);
        if (this.func_145838_q() instanceof BlockMini) {
            this.orientation = ((BlockMini)this.func_145838_q()).getOrientationFromPlacement(placer, face, stack, hitX, hitY, hitZ);
        }
    }

    public void loadFromStack(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("texture");
        if (tag != null) {
            this.state = NBTUtil.func_190008_d((NBTTagCompound)tag);
        }
    }

    public boolean changeOrientation(BaseOrientation newOrientation, boolean simulate) {
        if (this.orientation != newOrientation) {
            if (!simulate) {
                this.orientation = newOrientation;
                this.markBlockForUpdate();
                this.func_145831_w().func_175722_b(this.field_174879_c, this.func_145838_q(), true);
            }
            return true;
        }
        return false;
    }

    public void markBlockForRenderUpdate() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public void markBlockForUpdate() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public BaseOrientation getOrientation() {
        if (this.orientation == null) {
            return BaseOrientation.DEFAULT;
        }
        return this.orientation;
    }

    public IBlockState getState() {
        if (this.state == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.state;
    }

    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target, IBlockState state) {
        if (this.state != null && this.func_145838_q() instanceof BlockMini) {
            return MiniBlocks.fromParent(this.func_145838_q(), this.getState());
        }
        return ItemStack.field_190927_a;
    }
}

