/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module;

import betterwithmods.module.ModuleLoader;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;

public class ConfigHelper {
    public static boolean needsRestart;
    public static boolean allNeedRestart;
    public static HashMap<String, Boolean> CONDITIONS;

    public static void setDescription(String category, String comment) {
        ModuleLoader.config.setCategoryComment(category, comment);
    }

    public static boolean loadRecipeCondition(String jsonString, String propName, String category, String desc, boolean default_) {
        boolean value = ConfigHelper.loadPropBool(propName, category, desc, default_);
        CONDITIONS.put(jsonString, value);
        return value;
    }

    public static int[] loadPropIntList(String propName, String category, String comment, int[] default_) {
        Property prop = ModuleLoader.config.get(category, propName, default_, comment);
        ConfigHelper.setNeedsRestart(prop);
        return prop.getIntList();
    }

    public static int loadPropInt(String propName, String category, String desc, String comment, int default_, int min, int max) {
        Property prop = ModuleLoader.config.get(category, propName, default_, comment, min, max);
        prop.setComment(desc);
        ConfigHelper.setNeedsRestart(prop);
        return prop.getInt(default_);
    }

    public static int loadPropInt(String propName, String category, String desc, int default_) {
        Property prop = ModuleLoader.config.get(category, propName, default_);
        prop.setComment(desc);
        ConfigHelper.setNeedsRestart(prop);
        return prop.getInt(default_);
    }

    public static double loadPropDouble(String propName, String category, String desc, double default_) {
        Property prop = ModuleLoader.config.get(category, propName, default_);
        prop.setComment(desc);
        ConfigHelper.setNeedsRestart(prop);
        return prop.getDouble(default_);
    }

    public static double loadPropDouble(String propName, String category, String desc, double default_, double min, double max) {
        Property prop = ModuleLoader.config.get(category, propName, default_, desc, min, max);
        prop.setComment(desc);
        ConfigHelper.setNeedsRestart(prop);
        return prop.getDouble(default_);
    }

    public static boolean loadPropBool(String propName, String category, String desc, boolean default_) {
        Property prop = ModuleLoader.config.get(category, propName, default_);
        prop.setComment(desc);
        ConfigHelper.setNeedsRestart(prop);
        return prop.getBoolean(default_);
    }

    public static String loadPropString(String propName, String category, String desc, String default_) {
        Property prop = ModuleLoader.config.get(category, propName, default_);
        prop.setComment(desc);
        ConfigHelper.setNeedsRestart(prop);
        return prop.getString();
    }

    public static String[] loadPropStringList(String propName, String category, String desc, String[] default_) {
        Property prop = ModuleLoader.config.get(category, propName, default_);
        prop.setComment(desc);
        ConfigHelper.setNeedsRestart(prop);
        return prop.getStringList();
    }

    public static List<ResourceLocation> loadPropRLList(String propName, String category, String desc, String[] default_) {
        String[] l = ConfigHelper.loadPropStringList(propName, category, desc, default_);
        return Arrays.stream(l).map(ConfigHelper::rlFromString).collect(Collectors.toList());
    }

    public static Set<ResourceLocation> loadPropRLSet(String propName, String category, String desc, String[] default_) {
        String[] l = ConfigHelper.loadPropStringList(propName, category, desc, default_);
        return Arrays.stream(l).map(ConfigHelper::rlFromString).collect(Collectors.toSet());
    }

    public static ResourceLocation rlFromString(String loc) {
        String[] split = loc.split(":");
        if (split.length > 1) {
            return new ResourceLocation(split[0], split[1]);
        }
        return null;
    }

    public static Collection<IBlockState> statesFromString(String name) {
        String[] split = name.split(":");
        if (split.length > 1) {
            Block block;
            int meta = 0;
            if (split.length > 2) {
                meta = split[2].equalsIgnoreCase("*") ? Short.MAX_VALUE : Integer.parseInt(split[2]);
            }
            if ((block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0], split[1]))) != null) {
                if (meta == Short.MAX_VALUE) {
                    return block.func_176194_O().func_177619_a();
                }
                return Collections.singleton(block.func_176203_a(meta));
            }
        }
        return Collections.emptySet();
    }

    public static ItemStack stackFromString(String name) {
        String[] split = name.split(":");
        if (split.length > 1) {
            Item item;
            int meta = 0;
            if (split.length > 2) {
                meta = split[2].equalsIgnoreCase("*") ? Short.MAX_VALUE : Integer.parseInt(split[2]);
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1]))) != null) {
                return new ItemStack(item, 1, meta);
            }
        }
        return ItemStack.field_190927_a;
    }

    private static Ingredient ingredientfromString(String name) {
        if (name.startsWith("ore:")) {
            return new OreIngredient(name.substring(4));
        }
        String[] split = name.split(":");
        if (split.length > 1) {
            Item item;
            int meta = 0;
            if (split.length > 2) {
                meta = split[2].equalsIgnoreCase("*") ? Short.MAX_VALUE : Integer.parseInt(split[2]);
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1]))) != null) {
                return StackIngredient.fromStacks(new ItemStack(item, 1, meta));
            }
        }
        return Ingredient.field_193370_a;
    }

    private static String fromStack(ItemStack stack) {
        if (stack.func_77960_j() == Short.MAX_VALUE) {
            return String.format("%s:*", stack.func_77973_b().getRegistryName());
        }
        if (stack.func_77960_j() == 0) {
            return stack.func_77973_b().getRegistryName().toString();
        }
        return String.format("%s:%s", stack.func_77973_b().getRegistryName(), stack.func_77960_j());
    }

    public static List<ItemStack> loadItemStackList(String propName, String category, String desc, String[] default_) {
        return Arrays.stream(ConfigHelper.loadPropStringList(propName, category, desc, default_)).map(ConfigHelper::stackFromString).collect(Collectors.toList());
    }

    public static List<ItemStack> loadItemStackList(String propName, String category, String desc, ItemStack[] default_) {
        String[] strings_ = new String[default_.length];
        Arrays.stream(default_).map(ConfigHelper::fromStack).collect(Collectors.toList()).toArray(strings_);
        return ConfigHelper.loadItemStackList(propName, category, desc, strings_);
    }

    public static ItemStack[] loadItemStackArray(String propName, String category, String desc, String[] default_) {
        return (ItemStack[])Arrays.stream(ConfigHelper.loadPropStringList(propName, category, desc, default_)).map(ConfigHelper::stackFromString).toArray(ItemStack[]::new);
    }

    public static ItemStack[] loadItemStackArray(String propName, String category, String desc, ItemStack[] default_) {
        String[] strings_ = new String[default_.length];
        Arrays.stream(default_).map(ConfigHelper::fromStack).collect(Collectors.toList()).toArray(strings_);
        return ConfigHelper.loadItemStackArray(propName, category, desc, strings_);
    }

    public static HashMap<Ingredient, Integer> loadIngredientIntMap(String propName, String category, String desc, String[] _default) {
        String[] l;
        HashMap map = Maps.newHashMap();
        for (String s : l = ConfigHelper.loadPropStringList(propName, category, desc, _default)) {
            String[] a = s.split("=");
            if (a.length != 2) continue;
            map.put(ConfigHelper.ingredientfromString(a[0]), Integer.parseInt(a[1]));
        }
        return map;
    }

    public static HashMap<Integer, Integer> loadIntIntMap(String propName, String category, String desc, String[] _default) {
        String[] l;
        HashMap map = Maps.newHashMap();
        for (String s : l = ConfigHelper.loadPropStringList(propName, category, desc, _default)) {
            String[] a = s.split("=");
            if (a.length != 2) continue;
            map.put(Integer.parseInt(a[0]), Integer.parseInt(a[1]));
        }
        return map;
    }

    private static void setNeedsRestart(Property prop) {
        if (needsRestart) {
            prop.setRequiresMcRestart(needsRestart);
        }
        needsRestart = allNeedRestart;
    }

    static {
        allNeedRestart = false;
        CONDITIONS = Maps.newHashMap();
    }

    public static class ConditionConfig
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            String enabled = JsonUtils.func_151200_h((JsonObject)json, (String)"enabled");
            return () -> CONDITIONS.getOrDefault(enabled, false);
        }
    }
}

