/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.manual.common.api;

import betterwithmods.BWMod;
import betterwithmods.manual.api.detail.ManualDefinition;
import betterwithmods.manual.api.manual.ContentProvider;
import betterwithmods.manual.api.manual.ImageProvider;
import betterwithmods.manual.api.manual.ImageRenderer;
import betterwithmods.manual.api.manual.PathProvider;
import betterwithmods.manual.api.manual.TabIconRenderer;
import betterwithmods.manual.client.gui.GuiManual;
import betterwithmods.manual.client.manual.provider.BlockImageProvider;
import betterwithmods.manual.client.manual.provider.ItemImageProvider;
import betterwithmods.manual.client.manual.provider.OreDictImageProvider;
import betterwithmods.manual.client.manual.provider.TextureImageProvider;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ManualDefinitionImpl
implements ManualDefinition {
    public static final String LANGUAGE_KEY = "%LANGUAGE%";
    public static final String FALLBACK_LANGUAGE = "en_us";
    public static final Pattern PATTERN_LANGUAGE_KEY = Pattern.compile("%LANGUAGE%");
    public static final ManualDefinitionImpl INSTANCE = new ManualDefinitionImpl();
    private static final String MESSAGE_CONTENT_LOOKUP_EXCEPTION = "A content provider threw an error when queried.";
    private static final String MESSAGE_IMAGE_PROVIDER_EXCEPTION = "An image provider threw an error when queried.";
    private static final String MESSAGE_PATH_PROVIDER_ITEM_EXCEPTION = "A path provider threw an error when queried with an item.";
    private static final String MESSAGE_PATH_PROVIDER_BLOCK_EXCEPTION = "A path provider threw an error when queried with a block.";
    private final Stack<History> history = new Stack();
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final List<PathProvider> pathProviders = new ArrayList<PathProvider>();
    private final List<ContentProvider> contentProviders = new ArrayList<ContentProvider>();
    private final List<PrefixedImageProvider> imageProviders = new ArrayList<PrefixedImageProvider>();
    private String defaultPage = String.format("%s/index.md", "%LANGUAGE%");

    public ManualDefinitionImpl() {
        this.reset();
    }

    public static String makeRelative(String path, String base) {
        if (path.startsWith("/")) {
            return path;
        }
        int lastSlash = base.lastIndexOf(47);
        if (lastSlash >= 0) {
            return base.substring(0, lastSlash + 1) + path;
        }
        return path;
    }

    @Override
    public void addTab(TabIconRenderer renderer, @Nullable String tooltip, String path) {
        this.tabs.add(new Tab(renderer, tooltip, path));
        if (this.tabs.size() > 7) {
            BWMod.getLog().warn("Gosh I'm popular! Too many tabs were added to the in-game manual, so some won't be shown. In case this actually happens, let me know and I'll look into making them scrollable or something...");
        }
    }

    @Override
    public void addProvider(PathProvider provider) {
        if (!this.pathProviders.contains(provider)) {
            this.pathProviders.add(provider);
        }
    }

    @Override
    public void addProvider(ContentProvider provider) {
        if (!this.contentProviders.contains(provider)) {
            this.contentProviders.add(provider);
        }
    }

    @Override
    public void addProvider(String prefix, ImageProvider provider) {
        String actualPrefix = Strings.isNullOrEmpty((String)prefix) ? "" : prefix + ":";
        for (PrefixedImageProvider entry : this.imageProviders) {
            if (!entry.prefix.equals(actualPrefix) || entry.provider != provider) continue;
            return;
        }
        this.imageProviders.add(new PrefixedImageProvider(actualPrefix, provider));
    }

    @Override
    public void addDefaultProviders() {
        this.addProvider("", new TextureImageProvider("documentation/docs/img/"));
        this.addProvider("item", new ItemImageProvider());
        this.addProvider("block", new BlockImageProvider());
        this.addProvider("oredict", new OreDictImageProvider());
    }

    @Override
    @Nullable
    public String pathFor(ItemStack stack) {
        return this.pathFor((PathProvider p) -> p.pathFor(stack), MESSAGE_PATH_PROVIDER_ITEM_EXCEPTION);
    }

    @Override
    @Nullable
    public String pathFor(World world, BlockPos pos) {
        return this.pathFor((PathProvider p) -> p.pathFor(world, pos), MESSAGE_PATH_PROVIDER_BLOCK_EXCEPTION);
    }

    @Override
    @Nullable
    public Iterable<String> contentFor(String path) {
        String cleanPath = Files.simplifyPath((String)path);
        String language = FMLCommonHandler.instance().getCurrentLanguage();
        Optional<Iterable<String>> result = this.contentForWithRedirects(PATTERN_LANGUAGE_KEY.matcher(cleanPath).replaceAll(language));
        if (result.isPresent()) {
            return result.get();
        }
        return this.contentForWithRedirects(PATTERN_LANGUAGE_KEY.matcher(cleanPath).replaceAll(FALLBACK_LANGUAGE)).orElse(null);
    }

    @Override
    @Nullable
    public ImageRenderer imageFor(String href) {
        for (int i = this.imageProviders.size() - 1; i >= 0; --i) {
            PrefixedImageProvider entry = this.imageProviders.get(i);
            if (!href.startsWith(entry.prefix)) continue;
            try {
                ImageRenderer image = entry.provider.getImage(href.substring(entry.prefix.length()));
                if (image == null) continue;
                return image;
            }
            catch (Throwable t) {
                BWMod.getLog().warn(MESSAGE_IMAGE_PROVIDER_EXCEPTION, t);
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void openFor(EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiManual(this));
        }
    }

    @Override
    public void reset() {
        this.history.clear();
        this.history.push(new History(this.defaultPage));
    }

    @Override
    public void navigate(String path) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiManual) {
            ((GuiManual)screen).pushPage(path);
        } else {
            this.history.push(new History(path));
        }
    }

    @Override
    public void setDefaultPage(String defaultPage) {
        this.defaultPage = defaultPage;
        this.reset();
    }

    @Override
    public int getHistorySize() {
        return this.history.size();
    }

    @Override
    public void pushPath(String path) {
        this.history.push(new History(path));
    }

    @Override
    public String peekPath() {
        return this.history.peek().path;
    }

    @Override
    public int peekOffset() {
        return this.history.peek().offset;
    }

    @Override
    public void setOffset(int offset) {
        this.history.peek().offset = offset;
    }

    @Override
    public void popPath() {
        this.history.pop();
    }

    public List<Tab> getTabs() {
        return this.tabs;
    }

    @Nullable
    private String pathFor(ProviderQuery query, String warning) {
        for (PathProvider provider : this.pathProviders) {
            try {
                String path = query.pathFor(provider);
                if (path == null) continue;
                return path;
            }
            catch (Throwable t) {
                BWMod.getLog().warn(warning, t);
            }
        }
        return null;
    }

    private Optional<Iterable<String>> contentForWithRedirects(String path) {
        return this.contentForWithRedirects(path, new ArrayList<String>());
    }

    private Optional<Iterable<String>> contentForWithRedirects(String path, List<String> seen) {
        String line;
        Iterable<String> lines;
        Iterator<String> iterator;
        if (seen.contains(path)) {
            ArrayList<String> message = new ArrayList<String>();
            message.add("Redirection loop: ");
            message.addAll(seen);
            message.add(path);
            return Optional.of(message);
        }
        Optional<Iterable<String>> content = this.doContentLookup(path);
        if (content.isPresent() && (iterator = (lines = content.get()).iterator()).hasNext() && (line = iterator.next()).toLowerCase(Locale.US).startsWith("#redirect ")) {
            ArrayList<String> newSeen = new ArrayList<String>(seen);
            newSeen.add(path);
            return this.contentForWithRedirects(ManualDefinitionImpl.makeRelative(line.substring("#redirect ".length()), path), newSeen);
        }
        return content;
    }

    private Optional<Iterable<String>> doContentLookup(String path) {
        for (ContentProvider provider : this.contentProviders) {
            try {
                Iterable<String> lines = provider.getContent(path);
                if (lines == null) continue;
                return Optional.of(lines);
            }
            catch (Throwable t) {
                BWMod.getLog().warn(MESSAGE_CONTENT_LOOKUP_EXCEPTION, t);
            }
        }
        return Optional.empty();
    }

    private static final class PrefixedImageProvider {
        public final String prefix;
        public final ImageProvider provider;

        private PrefixedImageProvider(String prefix, ImageProvider provider) {
            this.prefix = prefix;
            this.provider = provider;
        }
    }

    public static final class Tab {
        public final TabIconRenderer renderer;
        public final String tooltip;
        public final String path;

        public Tab(TabIconRenderer renderer, @Nullable String tooltip, String path) {
            this.renderer = renderer;
            this.tooltip = tooltip;
            this.path = path;
        }
    }

    public static final class History {
        public final String path;
        public int offset = 0;

        public History(String path) {
            this.path = path;
        }
    }

    @FunctionalInterface
    private static interface ProviderQuery {
        @Nullable
        public String pathFor(PathProvider var1);
    }
}

