/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.potion;

import betterwithmods.common.potion.BWPotion;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;

public class PotionTruesight
extends BWPotion {
    public static boolean ignoreLayer = false;
    private static final AxisAlignedBB TEST_BB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 1.0, 0.7);

    public PotionTruesight(String name, boolean b, int potionColor) {
        super(name, b, potionColor);
    }

    @Override
    public void tick(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            Minecraft mc = Minecraft.func_71410_x();
            if (entity != mc.field_71439_g) {
                return;
            }
            int var3 = mc.field_71474_y.field_74362_aa;
            if (!(mc.func_147113_T() || world.field_73011_w.getDimension() != 0 && world.field_73011_w.getDimension() != 1)) {
                int entityX = MathHelper.func_76128_c((double)entity.field_70165_t);
                int var5 = MathHelper.func_76128_c((double)entity.field_70163_u);
                int var6 = MathHelper.func_76128_c((double)entity.field_70161_v);
                int radius = 10;
                for (int x = entityX - radius; x <= entityX + radius; ++x) {
                    for (int y = var5 - radius; y <= var5 + radius; ++y) {
                        for (int z = var6 - radius; z <= var6 + radius; ++z) {
                            if (!PotionTruesight.canSpawnMobsHere(world, new BlockPos(x, y, z)) || var3 != 0 && world.field_73012_v.nextInt(12) > 2 - var3 << 1) continue;
                            double i = (double)x + world.field_73012_v.nextDouble();
                            double j = (double)y + world.field_73012_v.nextDouble() * 0.25;
                            double k = (double)z + world.field_73012_v.nextDouble();
                            world.func_175688_a(EnumParticleTypes.SPELL_MOB, i, j, k, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                }
            }
        }
    }

    private static boolean canSpawnMobsHere(World world, BlockPos pos) {
        if (world.func_175642_b(EnumSkyBlock.BLOCK, pos) >= 8) {
            return false;
        }
        if (world.func_180494_b(pos).func_76747_a(EnumCreatureType.MONSTER).isEmpty()) {
            return false;
        }
        if (!WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)world, (BlockPos)pos)) {
            return false;
        }
        return PotionTruesight.checkCollision(pos, world);
    }

    private static boolean checkCollision(BlockPos pos, World world) {
        IBlockState block1 = world.func_180495_p(pos);
        if (block1.func_185915_l() || !ignoreLayer && world.func_180495_p(pos.func_177984_a()).func_185915_l()) {
            return false;
        }
        if (world.func_175623_d(pos) && (ignoreLayer || world.func_175623_d(pos.func_177984_a()))) {
            return true;
        }
        AxisAlignedBB bb = TEST_BB.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        if (world.func_184144_a(null, bb).isEmpty() && !world.func_72953_d(bb)) {
            if (ignoreLayer) {
                return true;
            }
            AxisAlignedBB bb2 = bb.func_72317_d(0.0, 1.0, 0.0);
            return world.func_184144_a(null, bb2).isEmpty() && !world.func_72953_d(bb2);
        }
        return false;
    }
}

