/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.items;

import betterwithmods.api.IMultiLocations;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMItems;
import betterwithmods.util.StackIngredient;
import java.util.ArrayList;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemMaterial
extends Item
implements IMultiLocations {
    public ItemMaterial() {
        this.func_77637_a(BWCreativeTabs.BWTAB);
        this.func_77627_a(true);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        if (EnumMaterial.VALUES[stack.func_77960_j()] == EnumMaterial.DIAMOND_INGOT && playerIn != null) {
            BlockPos pos = playerIn.func_180425_c().func_177984_a();
            worldIn.func_184133_a(null, playerIn.func_180425_c(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.1f, false);
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public int getItemBurnTime(ItemStack stack) {
        switch (EnumMaterial.VALUES[stack.func_77960_j()]) {
            case GEAR: {
                return 18;
            }
            case NETHERCOAL: {
                return 3200;
            }
            case SAWDUST: {
                return 25;
            }
            case WINDMILL_BLADE: {
                return 75;
            }
            case WOOD_BLADE: {
                return 37;
            }
            case HAFT: {
                return 150;
            }
        }
        return -1;
    }

    public static ItemStack getMaterial(EnumMaterial material) {
        return ItemMaterial.getMaterial(material, 1);
    }

    public static ItemStack getMaterial(EnumMaterial material, int count) {
        return new ItemStack(BWMItems.MATERIAL, count, material.getMetadata());
    }

    public static Ingredient getIngredient(EnumMaterial material) {
        return ItemMaterial.getIngredient(material, 1);
    }

    public static Ingredient getIngredient(EnumMaterial material, int count) {
        return StackIngredient.fromStacks(ItemMaterial.getMaterial(material, count));
    }

    @Override
    public String[] getLocations() {
        ArrayList<String> names = new ArrayList<String>();
        for (EnumMaterial material : EnumMaterial.values()) {
            names.add(material.getName());
        }
        return names.toArray(new String[EnumMaterial.values().length]);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (EnumMaterial material : EnumMaterial.values()) {
                items.add((Object)ItemMaterial.getMaterial(material));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + EnumMaterial.VALUES[stack.func_77960_j()].getName();
    }

    public static enum EnumMaterial {
        GEAR,
        NETHERCOAL,
        HEMP,
        HEMP_FIBERS,
        HEMP_CLOTH,
        DUNG,
        TANNED_LEATHER,
        SCOURED_LEATHER,
        LEATHER_STRAP,
        LEATHER_BELT,
        WOOD_BLADE,
        WINDMILL_BLADE,
        GLUE,
        TALLOW,
        INGOT_STEEL,
        GROUND_NETHERRACK,
        HELLFIRE_DUST,
        CONCENTRATED_HELLFIRE,
        COAL_DUST,
        FILAMENT,
        POLISHED_LAPIS,
        POTASH,
        SAWDUST,
        SOUL_DUST,
        SCREW,
        BRIMSTONE,
        NITER,
        ELEMENT,
        FUSE,
        BLASTING_OIL,
        NUGGET_STEEL,
        LEATHER_CUT,
        TANNED_LEATHER_CUT,
        SCOURED_LEATHER_CUT,
        REDSTONE_LATCH,
        NETHER_SLUDGE,
        HAFT,
        CHARCOAL_DUST,
        SOUL_FLUX,
        ENDER_SLAG,
        ENDER_OCULAR,
        PADDING,
        ARMOR_PLATE,
        BROADHEAD,
        COCOA_POWDER,
        DIAMOND_INGOT,
        DIAMOND_NUGGET,
        CHAIN_MAIL,
        STEEL_GEAR,
        STEEL_SPRING,
        SOAP,
        PLATE_STEEL,
        WITCH_WART,
        MYSTERY_GLAND,
        POISON_SAC;

        public static final EnumMaterial[] VALUES;

        public int getMetadata() {
            return this.ordinal();
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        static {
            VALUES = EnumMaterial.values();
        }
    }
}

