/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.common.blocks.tile.TileBasic;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public abstract class TileFluid
extends TileBasic {
    protected FluidTank tank = this.createTank();

    public FluidTank createTank() {
        FluidTank tank = new FluidTank(this.getCapacity());
        tank.setTileEntity((TileEntity)this);
        return tank;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = new NBTTagCompound();
        this.tank.writeToNBT(t);
        tag.func_74782_a("tank", (NBTBase)t);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (this.tank == null) {
            this.tank = this.createTank();
        }
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        super.func_145839_a(compound);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasFluid(facing) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.hasFluid(facing) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public boolean isFull() {
        return this.tank.getFluidAmount() >= this.tank.getCapacity();
    }

    public boolean fill(FluidStack stack, boolean doFill) {
        if (this.tank.fill(stack, doFill) != 0) {
            SoundEvent soundevent = stack.getFluid().getFillSound(stack);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public abstract int getCapacity();

    public abstract boolean hasFluid(EnumFacing var1);
}

