/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.IColor;
import betterwithmods.common.blocks.mechanical.tile.TileAxleGenerator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.DimensionType;

public abstract class TileEntityBaseWindmill
extends TileAxleGenerator
implements IColor {
    protected int[] bladeMeta;

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < this.bladeMeta.length; ++i) {
            if (!tag.func_74764_b("Color_" + i)) continue;
            this.bladeMeta[i] = tag.func_74762_e("Color_" + i);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        for (int i = 0; i < this.bladeMeta.length; ++i) {
            t.func_74768_a("Color_" + i, this.bladeMeta[i]);
        }
        t.func_74774_a("DyeIndex", this.dyeIndex);
        return t;
    }

    @Override
    public boolean dye(EnumDyeColor color) {
        boolean dyed = false;
        if (this.bladeMeta[this.dyeIndex] != color.func_176765_a()) {
            this.bladeMeta[this.dyeIndex] = color.func_176765_a();
            dyed = true;
            IBlockState state = this.getBlockWorld().func_180495_p(this.field_174879_c);
            this.getBlockWorld().func_184138_a(this.field_174879_c, state, state, 2);
            this.func_70296_d();
        }
        this.dyeIndex = (byte)(this.dyeIndex + 1);
        if (this.dyeIndex > this.bladeMeta.length - 1) {
            this.dyeIndex = 0;
        }
        return dyed;
    }

    public int getBladeColor(int blade) {
        return this.bladeMeta[blade];
    }

    @Override
    public int getColor(int index) {
        return this.bladeMeta[index];
    }

    @Override
    public void calculatePower() {
        int power = 0;
        if (this.isValid()) {
            power = this.field_145850_b.field_73011_w.func_186058_p() == DimensionType.OVERWORLD ? (this.field_145850_b.func_72911_I() ? 3 : (this.field_145850_b.func_72896_J() ? 2 : 1)) : 1;
        }
        if (power != this.power) {
            this.setPower((byte)power);
        }
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }
}

