/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.util.DirUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPane
extends BWMBlock {
    private final Map<PropertyBool, AxisAlignedBB> bounds = new HashMap<PropertyBool, AxisAlignedBB>(){
        {
            this.put(DirUtils.NORTH, new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 0.5625));
            this.put(DirUtils.SOUTH, new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 1.0));
            this.put(DirUtils.WEST, new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 1.0, 0.5625));
            this.put(DirUtils.EAST, new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 1.0, 0.5625));
        }
    };

    public BlockPane(Material material) {
        super(material);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean pass) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        float minY = 0.001f;
        float maxY = 0.999f;
        float minX = 0.4375f;
        float maxX = 0.5625f;
        float minZ = 0.4375f;
        float maxZ = 0.5625f;
        if (((Boolean)state.func_177229_b((IProperty)DirUtils.NORTH)).booleanValue()) {
            minZ = 0.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)DirUtils.SOUTH)).booleanValue()) {
            maxZ = 1.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)DirUtils.WEST)).booleanValue()) {
            minX = 0.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)DirUtils.EAST)).booleanValue()) {
            maxX = 1.0f;
        }
        AxisAlignedBB stick = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);
        BlockPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)stick);
        if (minZ == 0.0f || maxZ == 1.0f) {
            AxisAlignedBB extZ = new AxisAlignedBB(0.4375, (double)minY, (double)minZ, 0.5625, (double)maxY, (double)maxZ);
            BlockPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)extZ);
        }
        if (minX == 0.0f || maxX == 1.0f) {
            AxisAlignedBB extX = new AxisAlignedBB((double)minX, (double)minY, 0.4375, (double)maxX, (double)maxY, 0.5625);
            BlockPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)extX);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_185899_b(world, pos);
        AxisAlignedBB bound = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);
        for (PropertyBool dir : DirUtils.DIR_PROP_HORIZ) {
            if (!((Boolean)state.func_177229_b((IProperty)dir)).booleanValue()) continue;
            bound = bound.func_111270_a(this.bounds.get(dir));
        }
        return bound;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public final boolean isIncompatibleBlock(Block block) {
        return false;
    }

    public final boolean isFenceGate(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        IBlockState state = world.func_180495_p(pos.func_177972_a(dir));
        if (dir == EnumFacing.EAST || dir == EnumFacing.WEST) {
            return state.func_177230_c() instanceof BlockFenceGate && (state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) == EnumFacing.NORTH || state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) == EnumFacing.SOUTH);
        }
        return state.func_177230_c() instanceof BlockFenceGate && (state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) == EnumFacing.EAST || state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) == EnumFacing.WEST);
    }

    public boolean isCompatiblePane(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        BlockPos neighbor = pos.func_177972_a(dir);
        Block block = world.func_180495_p(neighbor).func_177230_c();
        return block instanceof BlockPane;
    }

    public boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        return this.isFenceGate(world, pos, dir) || this.isCompatiblePane(world, pos, dir) || world.isSideSolid(pos.func_177972_a(dir), dir.func_176734_d(), true);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean north = this.canConnectTo(world, pos, EnumFacing.NORTH);
        boolean east = this.canConnectTo(world, pos, EnumFacing.EAST);
        boolean south = this.canConnectTo(world, pos, EnumFacing.SOUTH);
        boolean west = this.canConnectTo(world, pos, EnumFacing.WEST);
        return state.func_177226_a((IProperty)DirUtils.NORTH, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)DirUtils.EAST, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)DirUtils.SOUTH, (Comparable)Boolean.valueOf(south)).func_177226_a((IProperty)DirUtils.WEST, (Comparable)Boolean.valueOf(west));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.CENTER_SMALL;
    }
}

