/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import betterwithmods.util.StackIngredient;
import betterwithmods.util.player.PlayerHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBrokenGearbox
extends BWMBlock {
    public static final PropertyInteger REPAIR = PropertyInteger.func_177719_a((String)"repair", (int)0, (int)1);
    public EnumTier type;
    public Ingredient repairIngredient;

    public BlockBrokenGearbox(EnumTier type) {
        super(Material.field_151575_d);
        this.type = type;
        this.repairIngredient = type == EnumTier.WOOD ? StackIngredient.fromStacks(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GEAR, 2)) : StackIngredient.fromStacks(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.STEEL_GEAR, 2));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (PlayerHelper.isHolding(playerIn, this.repairIngredient)) {
            if (InvUtils.usePlayerItemStrict(playerIn, EnumFacing.UP, this.repairIngredient, this.type == EnumTier.WOOD ? 2 : 4)) {
                Block block = this.type == EnumTier.WOOD ? BWMBlocks.WOODEN_GEARBOX : BWMBlocks.STEEL_GEARBOX;
                worldIn.func_175656_a(pos, block.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, state.func_177229_b((IProperty)DirUtils.FACING)));
                worldIn.func_184133_a(null, pos, SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, REPAIR});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.field_82609_l[meta & 3]).func_177226_a((IProperty)REPAIR, (Comparable)Integer.valueOf(meta >> 3));
    }

    public int func_176201_c(IBlockState state) {
        int facing = ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
        int type = (Integer)state.func_177229_b((IProperty)REPAIR);
        return facing | type << 3;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (this.type == EnumTier.STEEL) {
            return 4000.0f;
        }
        return 0.0f;
    }

    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        if (this.type == EnumTier.STEEL) {
            return 100.0f;
        }
        return 3.5f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (this.type == EnumTier.STEEL) {
            return SoundType.field_185852_e;
        }
        return SoundType.field_185848_a;
    }

    public Material func_149688_o(IBlockState state) {
        if (this.type == EnumTier.STEEL) {
            return Material.field_151573_f;
        }
        return Material.field_151575_d;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return this.type != EnumTier.STEEL || entity instanceof EntityPlayer;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (this.type != EnumTier.STEEL) {
            super.onBlockExploded(world, pos, explosion);
        }
    }
}

