/*
 * Decompiled with CFR 0.152.
 */
package seraphaestus.historicizedmedicine.Item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import seraphaestus.historicizedmedicine.Config;
import seraphaestus.historicizedmedicine.Effect.RegisterEffects;
import seraphaestus.historicizedmedicine.Item.IItemBaseData;
import seraphaestus.historicizedmedicine.Item.ItemBase;
import seraphaestus.historicizedmedicine.Item.ItemMask;
import seraphaestus.historicizedmedicine.Item.KnowledgeSheet;
import seraphaestus.historicizedmedicine.Item.MedKitBase;
import seraphaestus.historicizedmedicine.Item.MedKitFood;
import seraphaestus.historicizedmedicine.Item.MedKitTool;
import seraphaestus.historicizedmedicine.Item.PlagueCure;
import seraphaestus.historicizedmedicine.Item.SampleGlass;
import seraphaestus.historicizedmedicine.Util.Reduce;

public class RegistryHandler {
    public static List<IItemBaseData> items;
    public static KnowledgeSheet ebers;
    public static KnowledgeSheet corpus;
    public static KnowledgeSheet canon;
    public static KnowledgeSheet magna;
    private static Potion wither;
    private static Potion poison;

    public static void setupItems() {
        items = new ArrayList<IItemBaseData>();
        items.add(new ItemBase("herbs", 64, "herbs"));
        items.add(new MedKitTool("trephine", 1, -1, -1, new PotionEffect[]{RegistryHandler.pain(15.0f), RegistryHandler.bleed(30.0f, 1)}, new Potion[]{wither}, null, -2, 3));
        items.add(new MedKitFood("medicinal_clay", 8, -1, -1, null, null, null, 1, 1, 1));
        items.add(new MedKitBase("ward_charm", 1, -1, -1, null, null, null, 0));
        items.add(new MedKitBase("herbal_poultice", 8, -1, -1, null, null, new Reduce[]{new Reduce(RegisterEffects.pain, 100)}, 0));
        items.add(new MedKitBase("meat_bandage", 64, -1, -1, new PotionEffect[]{RegistryHandler.infect(30.0f)}, null, new Reduce[]{new Reduce(RegisterEffects.bleeding, 100)}, 0));
        if (Config.implementHoney) {
            items.add(new ItemBase("honey", 64, "itemHoney"));
        }
        items.add(new MedKitBase("honey_poultice", 8, -1, -1, null, null, new Reduce[]{new Reduce(RegisterEffects.pain, 300)}, 0));
        items.add(new ItemBase("suture", 64));
        items.add(new MedKitBase("ligature", 1, -1, -1, new PotionEffect[]{RegistryHandler.pain(25.0f)}, null, new Reduce[]{new Reduce(RegisterEffects.bleeding, 100)}, -4));
        items.add(new MedKitTool("scalpel", 1, -1, 10, new PotionEffect[]{RegistryHandler.pain(20.0f), RegistryHandler.infect(20.0f)}, null, null, 5, 10));
        items.add(new MedKitBase("reed_bandage", 64, -1, -1, new PotionEffect[]{RegistryHandler.infect(10.0f)}, null, new Reduce[]{new Reduce(RegisterEffects.bleeding, 200)}, 0));
        items.add(new MedKitBase("leech", 64, -1, -1, new PotionEffect[]{RegistryHandler.bleed(10.0f)}, new Potion[]{poison}, null, -1));
        items.add(new MedKitTool("cautery", 1, -1, -1, new PotionEffect[]{RegistryHandler.pain(40.0f), RegistryHandler.infect(20.0f)}, new Potion[]{RegisterEffects.bleeding}, null, -6, 20));
        items.add(new MedKitTool("razor", 1, -1, -1, new PotionEffect[]{RegistryHandler.pain(10.0f), RegistryHandler.infect(20.0f), RegistryHandler.bleed(30.0f)}, null, null, 10, 5));
        items.add(new ItemBase("theriac", 1));
        items.add(new ItemBase("unicorn_powder", 64));
        items.add(new PlagueCure());
        items.add(new ItemMask());
        items.add(new ItemBase("urine", 64));
        items.add(new SampleGlass());
        items.add(new ItemBase("ammonia", 64));
        items.add(new MedKitBase("nitrous_oxide", 64, -1, -1, null, new Potion[]{RegisterEffects.pain}, null, 0));
    }

    public static void preInitCommon() {
        if (items == null) {
            RegistryHandler.setupItems();
        }
        for (IItemBaseData item : items) {
            if (item instanceof Item) {
                Item item2 = (Item)item;
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)((Item)item2.setRegistryName(item.getId())).func_77655_b(item.getName()).func_77625_d(item.getStackSize()));
            }
            if (!(item instanceof ItemBase)) continue;
            ((ItemBase)item).init();
        }
        ArrayList<KnowledgeSheet> sheets = new ArrayList<KnowledgeSheet>();
        Item[] knowledge1 = new Item[]{RegistryHandler.iId("trephine")};
        Item[] knowledge2 = new Item[]{RegistryHandler.iId("trephine")};
        Item[] knowledge3 = new Item[]{RegistryHandler.iId("trephine")};
        Item[] knowledge4 = new Item[]{RegistryHandler.iId("trephine")};
        ebers = new KnowledgeSheet("ebers_papyrus", 4, knowledge1, Config.commandRunOnEbersUse, 1);
        corpus = new KnowledgeSheet("hippocratic_corpus", 8, knowledge2, Config.commandRunOnCorpusUse, 2);
        canon = new KnowledgeSheet("canon_of_medicine", 12, knowledge3, Config.commandRunOnCanonUse, 3);
        magna = new KnowledgeSheet("chirurgia_magna", 16, knowledge4, Config.commandRunOnMagnaUse, 4);
        sheets.add(ebers);
        sheets.add(corpus);
        sheets.add(canon);
        sheets.add(magna);
        for (ItemBase itemBase : sheets) {
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)((Item)itemBase.setRegistryName(itemBase.id)).func_77655_b(itemBase.name).func_77625_d(itemBase.stackSize));
        }
    }

    public static void preInitClientOnly() {
        boolean DEFAULT_ITEM_SUBTYPE = false;
        if (items == null) {
            RegistryHandler.setupItems();
        }
        for (IItemBaseData item : items) {
            ModelResourceLocation itemModelResourceLocation = new ModelResourceLocation("historicizedmedicine:" + item.getId(), "inventory");
            if (!(item instanceof Item)) continue;
            Item item2 = (Item)item;
            ModelLoader.setCustomModelResourceLocation((Item)item2, (int)0, (ModelResourceLocation)itemModelResourceLocation);
        }
        ModelResourceLocation itemModelResourceLocation = new ModelResourceLocation("historicizedmedicine:ebers_papyrus", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_111206_d((String)"historicizedmedicine:ebers_papyrus"), (int)0, (ModelResourceLocation)itemModelResourceLocation);
        itemModelResourceLocation = new ModelResourceLocation("historicizedmedicine:hippocratic_corpus", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_111206_d((String)"historicizedmedicine:hippocratic_corpus"), (int)0, (ModelResourceLocation)itemModelResourceLocation);
        itemModelResourceLocation = new ModelResourceLocation("historicizedmedicine:canon_of_medicine", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_111206_d((String)"historicizedmedicine:canon_of_medicine"), (int)0, (ModelResourceLocation)itemModelResourceLocation);
        itemModelResourceLocation = new ModelResourceLocation("historicizedmedicine:chirurgia_magna", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_111206_d((String)"historicizedmedicine:chirurgia_magna"), (int)0, (ModelResourceLocation)itemModelResourceLocation);
    }

    public static PotionEffect pain(float d) {
        return new PotionEffect(RegisterEffects.pain, (int)(d * 20.0f));
    }

    public static PotionEffect bleed(float d) {
        return new PotionEffect(RegisterEffects.bleeding, (int)(d * 20.0f));
    }

    public static PotionEffect bleed(float d, int level) {
        return new PotionEffect(RegisterEffects.bleeding, (int)(d * 20.0f), level);
    }

    public static PotionEffect infect(float d) {
        return new PotionEffect(RegisterEffects.infection, (int)(d * 20.0f));
    }

    public static Potion pId(int id) {
        return Potion.func_188412_a((int)id);
    }

    public static Item iId(String id) {
        return Item.func_111206_d((String)("historicizedmedicine:" + id));
    }

    static {
        wither = RegistryHandler.pId(20);
        poison = RegistryHandler.pId(19);
    }
}

