/*
 * Decompiled with CFR 0.152.
 */
package seraphaestus.historicizedmedicine.Item;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import seraphaestus.historicizedmedicine.Config;
import seraphaestus.historicizedmedicine.Item.ItemBase;
import seraphaestus.historicizedmedicine.Item.KnowledgeSheet;
import seraphaestus.historicizedmedicine.Item.RegistryHandler;
import seraphaestus.historicizedmedicine.Util.PotionName;
import seraphaestus.historicizedmedicine.Util.Reduce;

public class MedKitBase
extends ItemBase {
    protected int minHealthReq = -1;
    protected int maxHealthReq = -1;
    protected PotionEffect[] effect;
    protected Potion[] cure;
    protected Reduce[] reduce;
    protected int heal = 0;

    public MedKitBase(String id, int stackSize, int minHealth, int maxHealth, PotionEffect[] effect, Potion[] cure, Reduce[] reduce, int heal) {
        super(id, stackSize);
        this.minHealthReq = minHealth;
        this.maxHealthReq = maxHealth;
        this.effect = effect;
        this.cure = cure;
        this.reduce = reduce;
        this.heal = heal;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public void knowledgeHandler(EntityPlayer playerIn) {
        NonNullList inv = playerIn.field_71071_by.field_70462_a;
        try {
            inv.addAll((Collection)playerIn.field_71071_by.field_184439_c);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ItemStack i : inv) {
            if (!(i.func_77973_b() instanceof KnowledgeSheet)) continue;
            KnowledgeSheet kS = (KnowledgeSheet)i.func_77973_b();
            if (kS.isFull(i)) {
                return;
            }
            if (kS.id == RegistryHandler.ebers.id) {
                kS = RegistryHandler.ebers;
            }
            for (Item i2 : kS.getKnGivers()) {
                if (!(i2 instanceof ItemBase)) continue;
                ItemBase ibase = (ItemBase)i2;
                if (this.id != ibase.id) continue;
                kS.addKnowledge(i);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackHeld = playerIn.func_184586_b(hand);
        if ((this.minHealthReq == -1 || playerIn.func_110143_aJ() > (float)this.minHealthReq) && (this.maxHealthReq == -1 || playerIn.func_110143_aJ() < (float)this.maxHealthReq)) {
            playerIn.func_184598_c(hand);
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackHeld);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackHeld);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        float f;
        int dur;
        PotionEffect pe;
        if (entityLiving instanceof EntityPlayer) {
            this.knowledgeHandler((EntityPlayer)entityLiving);
        }
        if (this.effect != null) {
            for (PotionEffect potionEffect : this.effect) {
                pe = entityLiving.func_70660_b(potionEffect.func_188419_a());
                dur = 0;
                if (pe != null) {
                    dur = pe.func_76459_b();
                    entityLiving.func_184596_c(potionEffect.func_188419_a());
                }
                PotionEffect potionEffect2 = new PotionEffect(potionEffect.func_188419_a(), potionEffect.func_76459_b() + dur);
                entityLiving.func_70690_d(new PotionEffect(potionEffect2));
            }
        }
        if (this.cure != null) {
            for (Potion potion : this.cure) {
                entityLiving.func_184589_d(potion);
            }
        }
        if (this.reduce != null) {
            for (Reduce reduce : this.reduce) {
                pe = entityLiving.func_70660_b(reduce.x);
                if (pe == null) continue;
                dur = pe.func_76459_b();
                entityLiving.func_184596_c(reduce.x);
                if (dur - reduce.y <= 0) continue;
                entityLiving.func_70690_d(new PotionEffect(reduce.x, dur - reduce.y));
            }
        }
        if ((f = entityLiving.func_110143_aJ() + (float)this.heal) > entityLiving.func_110138_aP()) {
            f = entityLiving.func_110138_aP();
        }
        entityLiving.func_70606_j(f);
        this.extraEffects(entityLiving);
        this.consumption(stack, entityLiving);
        return stack;
    }

    protected void consumption(ItemStack stack, EntityLivingBase entityIn) {
        stack.func_190920_e(stack.func_190916_E() - 1);
    }

    protected void extraEffects(EntityLivingBase entityLiving) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        boolean tooltipEmpty = true;
        if (GuiScreen.func_146272_n()) {
            if (Config.canViewHealAmountInTooltip) {
                if (this.heal > 0) {
                    tooltip.add("Heals " + (float)this.heal / 2.0f + " hearts");
                    tooltipEmpty = false;
                } else if (this.heal < 0) {
                    tooltip.add("Damages by " + (float)this.heal / -2.0f + " hearts");
                    tooltipEmpty = false;
                }
            }
            if (Config.canViewEffectsInTooltip) {
                if (this.cure != null) {
                    for (Potion potion : this.cure) {
                        tooltip.add("Cures " + PotionName.potionName(potion));
                    }
                    tooltipEmpty = false;
                }
                if (this.reduce != null) {
                    for (Reduce reduce : this.reduce) {
                        tooltip.add("Reduces " + PotionName.potionName(reduce.x) + " duration by " + (float)reduce.y / 20.0f + " seconds");
                    }
                    tooltipEmpty = false;
                }
                if (this.effect != null) {
                    for (PotionEffect potionEffect : this.effect) {
                        tooltip.add("Gives " + PotionName.potionName(potionEffect.func_188419_a()) + " for " + (float)potionEffect.func_76459_b() / 20.0f + " seconds");
                    }
                    tooltipEmpty = false;
                }
                if (tooltipEmpty) {
                    tooltip.add("Effect: ???");
                }
            } else {
                tooltip.add("Effect: ???");
            }
        } else {
            tooltip.add("Shift to view effects of use");
            if (this.minHealthReq != -1 || this.maxHealthReq != -1) {
                boolean bl;
                int n = this.minHealthReq;
                int max = this.maxHealthReq;
                if (n == -1) {
                    bl = false;
                }
                if (max == -1) {
                    tooltip.add("Usable when above " + (float)bl / 2.0f + " hearts");
                } else {
                    tooltip.add("Usable between " + (float)bl / 2.0f + " and " + (float)max / 2.0f + " hearts");
                }
            }
        }
    }
}

