/*
 * Decompiled with CFR 0.152.
 */
package seraphaestus.historicizedmedicine.Item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import seraphaestus.historicizedmedicine.Config;
import seraphaestus.historicizedmedicine.Item.ItemBase;

public class KnowledgeSheet
extends ItemBase {
    private int maxKnowledge;
    private Item[] knowledgeGivers;
    private String useCommand;
    private int tier = 0;

    public KnowledgeSheet(String id, int maxKnowledge, Item[] knowledgeGivers, String useCmd, int tier) {
        super(id, 1);
        this.maxKnowledge = maxKnowledge;
        this.knowledgeGivers = knowledgeGivers;
        this.useCommand = useCmd;
        this.tier = tier;
    }

    public int getTier() {
        return this.tier;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public Item[] getKnGivers() {
        return this.knowledgeGivers;
    }

    public void addKnowledge(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            stack.func_77982_d(new NBTTagCompound());
            return;
        }
        int knowledge = nbt.func_74762_e("currentKnowledge");
        if (knowledge + 1 <= this.maxKnowledge) {
            nbt.func_74768_a("currentKnowledge", knowledge + 1);
        }
    }

    public void takeKnowledge(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            stack.func_77982_d(new NBTTagCompound());
            return;
        }
        int knowledge = nbt.func_74762_e("currentKnowledge");
        if (knowledge - 1 >= 0) {
            nbt.func_74768_a("currentKnowledge", knowledge - 1);
        }
    }

    public void setMaxKnowledge(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            stack.func_77982_d(new NBTTagCompound());
            return;
        }
        KnowledgeSheet ks = (KnowledgeSheet)stack.func_77973_b();
        nbt.func_74768_a("currentKnowledge", ks.maxKnowledge);
    }

    private int getCurrentKnowledge(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            stack.func_77982_d(new NBTTagCompound());
            return 0;
        }
        return nbt.func_74762_e("currentKnowledge");
    }

    public boolean isFull(ItemStack stack) {
        return this.maxKnowledge == this.getCurrentKnowledge(stack);
    }

    public boolean isEmpty(ItemStack stack) {
        return 0 == this.getCurrentKnowledge(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add("Knowledge: " + this.getCurrentKnowledge(stack) + "/" + this.maxKnowledge);
        if (GuiScreen.func_146272_n()) {
            tooltip.add("Use medical items to increase your knowledge which will advance you to the next stage of medical understanding");
        }
    }

    public int func_77626_a(ItemStack stack) {
        if (this.useCommand != null) {
            return 1;
        }
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackHeld = playerIn.func_184586_b(hand);
        if (this.isFull(itemStackHeld)) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackHeld);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackHeld);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (this.useCommand != null) {
            worldIn.func_73046_m().func_71187_D().func_71556_a((ICommandSender)worldIn.func_73046_m().func_174793_f(), this.useCommand);
            if (Config.knowledgeSheetConsumed) {
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
        }
        return stack;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isFull(stack);
    }
}

