/*
 * Decompiled with CFR 0.152.
 */
package seraphaestus.historicizedmedicine.Effect;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import seraphaestus.historicizedmedicine.Block.RegistryHandler;
import seraphaestus.historicizedmedicine.Config;
import seraphaestus.historicizedmedicine.Effect.PlagueEffect;
import seraphaestus.historicizedmedicine.Effect.RegisterEffects;
import seraphaestus.historicizedmedicine.HardCodedValues;
import seraphaestus.historicizedmedicine.Item.ItemMask;
import seraphaestus.historicizedmedicine.Mob.PlagueDoctor.EntityPlagueDoctor;
import seraphaestus.historicizedmedicine.Mob.Rat.EntityRat;

public class EntityUpdate {
    private static final int plagueParticleEveryXTicks = 6;
    private static HashMap<UUID, Integer> currentBleedDur = new HashMap();
    private static Field foodTimerField = null;

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            Iterator armor = player.func_184193_aE().iterator();
            boolean wearingMask = false;
            while (armor.hasNext()) {
                if (!(((ItemStack)armor.next()).func_77973_b() instanceof ItemMask)) continue;
                wearingMask = true;
                break;
            }
            if (wearingMask) {
                player.func_70690_d(new PotionEffect(RegisterEffects.plagueImmunity, 10, 0, true, false));
            }
            NBTTagCompound nbt = player.getEntityData();
            for (String id : RegistryHandler.statues) {
                int cooldown = nbt.func_74762_e(id + "_cooldown");
                if (cooldown == 0) continue;
                nbt.func_74768_a(id + "_cooldown", cooldown - 1);
            }
            if (player.func_70644_a(RegisterEffects.bleeding) && !player.field_71075_bZ.field_75098_d) {
                Integer bleedTick;
                PotionEffect pot = player.func_70660_b(RegisterEffects.bleeding);
                if (currentBleedDur.get(player.func_110124_au()) == null) {
                    currentBleedDur.put(player.func_110124_au(), pot.func_76459_b());
                }
                if ((bleedTick = currentBleedDur.get(player.func_110124_au())) != null) {
                    bleedTick = bleedTick / (Config.bleedTotalAmount * (pot.func_76458_c() + 1));
                    if (pot.func_76459_b() % bleedTick == 0 && player.func_110143_aJ() < 1.0f) {
                        player.func_70606_j(player.func_110143_aJ() - 1.0f);
                    }
                }
            } else {
                currentBleedDur.remove(player.func_110124_au());
            }
            if (player.func_70644_a(RegisterEffects.pain) && !player.field_71075_bZ.field_75098_d) {
                player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)2), 5, 1, true, false));
                player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)18), 5, 0, true, false));
            }
            if (player.func_70644_a(RegisterEffects.infection) && !player.field_71075_bZ.field_75098_d) {
                this.resetFoodTimer(player.func_71024_bL());
            }
            if (player.func_70644_a(RegisterEffects.plague) && !player.field_71075_bZ.field_75098_d) {
                for (Entity entity : player.func_130014_f_().field_72996_f) {
                    if (!HardCodedValues.catchesPlague(entity) || !(entity instanceof EntityLiving) || ((EntityLiving)entity).func_70644_a(RegisterEffects.plague) || ((EntityLiving)entity).func_70644_a(RegisterEffects.plagueImmunity) || !(player.func_70032_d(entity) <= Config.plagueRange)) continue;
                    ((EntityLiving)entity).func_70690_d(new PotionEffect(RegisterEffects.plague, Config.plagueDuration));
                    if (!entity.func_145818_k_() || player.func_130014_f_().field_72995_K) continue;
                    TextComponentString message = new TextComponentString(entity.func_95999_t() + " has caught " + Config.plagueName);
                    List players = player.func_130014_f_().field_73010_i;
                    for (EntityPlayer p : players) {
                        p.func_145747_a((ITextComponent)message);
                    }
                }
            }
        } else {
            if (!(event.getEntityLiving() instanceof EntityLiving)) {
                return;
            }
            EntityLiving entity = (EntityLiving)event.getEntityLiving();
            if (entity.func_70644_a(RegisterEffects.plague) && Config.enablePlague) {
                int plagueDuration = entity.func_70660_b(RegisterEffects.plague).func_76459_b();
                if (entity instanceof EntityPlagueDoctor) {
                    entity.func_184596_c(RegisterEffects.plague);
                }
                if (plagueDuration != 0) {
                    if (plagueDuration == 1 && !(entity instanceof EntityRat)) {
                        entity.func_70097_a(new DamageSource("HMedPlague"), entity.func_110143_aJ() + 1.0f);
                        if (entity.func_145818_k_() && !entity.func_130014_f_().field_72995_K) {
                            TextComponentString message = new TextComponentString(entity.func_95999_t() + " succumbed to " + Config.plagueName);
                            List players = entity.func_130014_f_().field_73010_i;
                            for (EntityPlayer p : players) {
                                p.func_145747_a((ITextComponent)message);
                            }
                        }
                    }
                    World world = entity.func_130014_f_();
                    Random rnd = entity.func_70681_au();
                    if (world.field_72995_K && plagueDuration % 6 == 0) {
                        this.renderParticles((Entity)entity, rnd);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderParticles(Entity entity, Random rnd) {
        AxisAlignedBB box = entity.func_174813_aQ();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new PlagueEffect(entity.func_130014_f_(), entity.field_70165_t + (box.field_72336_d - box.field_72340_a) * (double)(rnd.nextFloat() - 0.5f), entity.field_70163_u + (box.field_72337_e - box.field_72338_b) * (double)rnd.nextFloat(), entity.field_70161_v + (box.field_72334_f - box.field_72339_c) * (double)(rnd.nextFloat() - 0.5f), 0.0, 0.0, 0.0));
    }

    private void resetFoodTimer(FoodStats foodStats) {
        if (foodTimerField == null) {
            foodTimerField = ObfuscationReflectionHelper.findField(FoodStats.class, (String)"field_75123_d");
        }
        if (foodStats.func_75116_a() > 0) {
            try {
                foodTimerField.set(foodStats, 0);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

