/*
 * Decompiled with CFR 0.152.
 */
package seraphaestus.historicizedmedicine.CraftingTable;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Recipe
implements IRecipe {
    public NBTTagCompound[][] grid = new NBTTagCompound[3][3];
    public ItemStack output;
    public Item requiredSheet = null;
    private ResourceLocation recipeRegistryName;

    public Recipe() {
        for (int i = 0; i < 3; ++i) {
            for (int ii = 0; ii < 3; ++ii) {
                this.grid[i][ii] = null;
            }
        }
    }

    public Recipe(Recipe base) {
        for (int i = 0; i < 3; ++i) {
            for (int ii = 0; ii < 3; ++ii) {
                this.grid[i][ii] = base.grid[i][ii].func_74737_b();
            }
        }
        this.output = base.output.func_77946_l();
        this.requiredSheet = base.requiredSheet;
    }

    public Recipe(NBTTagCompound[][] grid, ItemStack output) {
        this.grid = grid;
        this.output = output;
    }

    public Recipe(NBTTagCompound[][] grid, ItemStack output, Item requiredSheet) {
        this(grid, output);
        this.requiredSheet = requiredSheet;
    }

    public static Recipe getFromJson(String contents) {
        try {
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)contents);
            Recipe output = new Recipe();
            NBTTagCompound outputTag = nbt.func_74775_l("result");
            output.output = new ItemStack(Item.func_111206_d((String)outputTag.func_74779_i("item")), outputTag.func_74762_e("amount"));
            output.requiredSheet = Item.func_111206_d((String)nbt.func_74779_i("knowledge"));
            for (int i = 0; i < 3; ++i) {
                output.grid[0][i] = nbt.func_74775_l("top" + (i + 1));
                output.grid[1][i] = nbt.func_74775_l("mid" + (i + 1));
                output.grid[2][i] = nbt.func_74775_l("low" + (i + 1));
            }
            return output;
        }
        catch (NBTException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.recipeRegistryName = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.recipeRegistryName;
    }

    public Class<IRecipe> getRegistryType() {
        return null;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return null;
    }

    public boolean func_194133_a(int width, int height) {
        return width == 3 && height == 3;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }
}

