/*
 * Decompiled with CFR 0.152.
 */
package seraphaestus.historicizedmedicine.CraftingTable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import seraphaestus.historicizedmedicine.Config;
import seraphaestus.historicizedmedicine.CraftingTable.Recipe;
import seraphaestus.historicizedmedicine.CraftingTable.UnrecursiveItemStackHandler;
import seraphaestus.historicizedmedicine.HardCodedValues;
import seraphaestus.historicizedmedicine.Item.KnowledgeSheet;
import seraphaestus.historicizedmedicine.ServerProxy;

public class CraftingTableTileEntity
extends TileEntity {
    public static final int size = 11;
    static final int outputSlot = 10;
    static final int knowledgeSlot = 9;
    UnrecursiveItemStackHandler itemStackHandlerMain = new UnrecursiveItemStackHandler(11){

        protected void onContentsChanged(int slot) {
            try {
                CraftingTableTileEntity.this.goThroughRecipes();
            }
            catch (IOException e) {
                System.out.println(e.getLocalizedMessage());
            }
            if (slot == 10) {
                if (Config.craftingConsumesKnowledge) {
                    ItemStack is = CraftingTableTileEntity.this.itemStackHandlerMain.getStackInSlot(9).func_77946_l();
                    KnowledgeSheet ks = (KnowledgeSheet)is.func_77973_b();
                    ks.takeKnowledge(is);
                    CraftingTableTileEntity.this.itemStackHandlerMain.setStackInSlot(9, is, false);
                }
                for (int i = 0; i < 9; ++i) {
                    ItemStack is = CraftingTableTileEntity.this.itemStackHandlerMain.getStackInSlot(i);
                    if (is.func_190916_E() <= 1) {
                        CraftingTableTileEntity.this.itemStackHandlerMain.setStackInSlot(i, ItemStack.field_190927_a, false);
                        continue;
                    }
                    CraftingTableTileEntity.this.itemStackHandlerMain.setStackInSlot(i, new ItemStack(is.func_77973_b(), is.func_190916_E() - 1), false);
                }
                try {
                    CraftingTableTileEntity.this.goThroughRecipes();
                }
                catch (IOException e) {
                    System.out.println(e.getLocalizedMessage());
                }
            }
            CraftingTableTileEntity.this.func_70296_d();
        }
    };

    private boolean goThroughRecipes() throws IOException {
        List<String> files = HardCodedValues.getRecipeFilePaths();
        for (String path : files) {
            BufferedReader readIn = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("assets/historicizedmedicine/textures/hmedcraftingtablerecipes/" + path + ".json"), "UTF-8"));
            String contents = "";
            String line = "first line, woo";
            while (line != null) {
                line = readIn.readLine();
                if (line == null) continue;
                contents = contents + line;
            }
            if (!this.verifyIfRecipe(contents)) continue;
            return true;
        }
        for (Recipe r : ServerProxy.getCustomRecipes()) {
            if (!this.verifyIfRecipe(r)) continue;
            return true;
        }
        return false;
    }

    private boolean verifyIfRecipe(String contents) {
        Recipe r = Recipe.getFromJson(contents);
        return this.verifyIfRecipe(r);
    }

    private boolean verifyIfRecipe(Recipe r) {
        this.itemStackHandlerMain.setStackInSlot(10, ItemStack.field_190927_a, false);
        if (this.itemCheck(r.grid[0][0], 0) && this.itemCheck(r.grid[0][1], 1) && this.itemCheck(r.grid[0][2], 2) && this.itemCheck(r.grid[1][0], 3) && this.itemCheck(r.grid[1][1], 4) && this.itemCheck(r.grid[1][2], 5) && this.itemCheck(r.grid[2][0], 6) && this.itemCheck(r.grid[2][1], 7) && this.itemCheck(r.grid[2][2], 8)) {
            boolean checkKnowledge = false;
            if (r.requiredSheet == null) {
                checkKnowledge = true;
            } else {
                ItemStack sheet = this.itemStackHandlerMain.getStackInSlot(9);
                if (!sheet.func_190926_b()) {
                    boolean knowledgeSheetCheck;
                    if (Config.requireExactTier) {
                        knowledgeSheetCheck = sheet.func_77973_b().getRegistryName() == r.requiredSheet.getRegistryName();
                    } else {
                        KnowledgeSheet ks = (KnowledgeSheet)sheet.func_77973_b();
                        KnowledgeSheet ks2 = (KnowledgeSheet)r.requiredSheet;
                        boolean bl = knowledgeSheetCheck = ks.getTier() >= ks2.getTier();
                    }
                    if (knowledgeSheetCheck) {
                        KnowledgeSheet knSheet = (KnowledgeSheet)sheet.func_77973_b();
                        if (!Config.fullKnowledgeRequired) {
                            if (!knSheet.isEmpty(sheet)) {
                                checkKnowledge = true;
                            }
                        } else if (knSheet.isFull(sheet)) {
                            checkKnowledge = true;
                        }
                    }
                }
            }
            if (r.requiredSheet == null || checkKnowledge) {
                this.itemStackHandlerMain.setStackInSlot(10, r.output, false);
                return true;
            }
        }
        return false;
    }

    private boolean itemCheck(NBTTagCompound nbt, int slot) {
        try {
            Item i;
            ItemStack isCheck = this.itemStackHandlerMain.getStackInSlot(slot).func_77946_l();
            if (isCheck.func_190926_b() && nbt.func_82582_d()) {
                return true;
            }
            if (isCheck.func_190926_b() || nbt.func_82582_d()) {
                return false;
            }
            Item check = isCheck.func_77973_b();
            String item = nbt.func_74779_i("item");
            if (item != "" && (i = Item.func_111206_d((String)item)) != null) {
                if (nbt.func_74762_e("meta") != 0) {
                    return check.getRegistryName() == i.getRegistryName() && nbt.func_74762_e("meta") == isCheck.func_77960_j();
                }
                return check.getRegistryName() == i.getRegistryName();
            }
            String ore = nbt.func_74779_i("ore");
            if (ore != "") {
                NonNullList oreMatches = OreDictionary.getOres((String)ore);
                for (ItemStack is : oreMatches) {
                    if (check.getRegistryName() != is.func_77973_b().getRegistryName()) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            System.out.println("oh noes");
            return false;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            this.itemStackHandlerMain.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("items", (NBTBase)this.itemStackHandlerMain.serializeNBT());
        return compound;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandlerMain);
        }
        return (T)super.getCapability(capability, facing);
    }
}

