/*
 * Decompiled with CFR 0.152.
 */
package seraphaestus.historicizedmedicine.Compat.JEI;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import seraphaestus.historicizedmedicine.Compat.JEI.HMedRecipeCategory;
import seraphaestus.historicizedmedicine.Compat.JEI.HMedRecipeHandler;
import seraphaestus.historicizedmedicine.Config;
import seraphaestus.historicizedmedicine.CraftingTable.CraftingTableGUI;
import seraphaestus.historicizedmedicine.CraftingTable.Recipe;
import seraphaestus.historicizedmedicine.HardCodedValues;
import seraphaestus.historicizedmedicine.ServerProxy;

@JEIPlugin
public class JEICompat
implements IModPlugin {
    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new HMedRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new HMedRecipeHandler()});
        registry.addRecipeClickArea(CraftingTableGUI.class, 88, 32, 28, 23, new String[]{"HMedCrafting"});
        List<Object> toAdd = new ArrayList();
        try {
            toAdd = this.getRecipes();
        }
        catch (IOException e) {
            System.out.println(e.getLocalizedMessage());
        }
        System.out.println("Adding " + toAdd.size() + " recipes for Medical Crafting table (JEI viewer)");
        registry.addRecipes(toAdd, "HMedCrafting");
        if (Config.implementHoney) {
            registry.addIngredientInfo((Object)new ItemStack(Item.func_111206_d((String)"historicizedmedicine:honey")), ItemStack.class, new String[]{"Obtain via trading with Apothecarian villagers"});
        }
        registry.addIngredientInfo((Object)new ItemStack(Item.func_111206_d((String)"historicizedmedicine:leech")), ItemStack.class, new String[]{"Obtain via trading with Plague Doctor villagers"});
        registry.addIngredientInfo((Object)new ItemStack(Item.func_111206_d((String)"historicizedmedicine:urine")), ItemStack.class, new String[]{"Obtain by using the sample glass"});
        registry.addIngredientInfo((Object)new ItemStack(Item.func_111206_d((String)"historicizedmedicine:theriac")), ItemStack.class, new String[]{"Obtain via trading with Apothecarian villagers"});
        registry.addIngredientInfo((Object)new ItemStack(Item.func_111206_d((String)"historicizedmedicine:unicorn_powder")), ItemStack.class, new String[]{"Obtain via trading with Plague Doctor villagers"});
        registry.addIngredientInfo((Object)new ItemStack(Item.func_111206_d((String)"historicizedmedicine:plague_mask")), ItemStack.class, new String[]{"Drops from Plague Doctor villagers"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(Item.func_111206_d((String)"historicizedmedicine:crafting_table")), new String[]{"HMedCrafting"});
        IIngredientBlacklist ingredientBlacklist = registry.getJeiHelpers().getIngredientBlacklist();
        ingredientBlacklist.addIngredientToBlacklist((Object)new ItemStack(Items.field_151144_bL, 1, 3));
    }

    private List<Recipe> getRecipes() throws IOException {
        ArrayList<Recipe> output = new ArrayList<Recipe>();
        List<String> files = HardCodedValues.getRecipeFilePaths();
        for (String path : files) {
            BufferedReader readIn = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("assets/historicizedmedicine/textures/hmedcraftingtablerecipes/" + path + ".json"), "UTF-8"));
            String contents = "";
            String line = "first line, woo";
            while (line != null) {
                line = readIn.readLine();
                if (line == null) continue;
                contents = contents + line;
            }
            output.add(Recipe.getFromJson(contents));
        }
        output.addAll(ServerProxy.getCustomRecipes());
        return output;
    }
}

