/*
 * Decompiled with CFR 0.152.
 */
package seraphaestus.historicizedmedicine.Compat.JEI;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import seraphaestus.historicizedmedicine.CraftingTable.Recipe;

public class HMedRecipeWrapper
implements IRecipeWrapper {
    public final List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    public final ItemStack output;
    public final ItemStack knowledge;

    public HMedRecipeWrapper(Recipe recipe) {
        for (int i = 0; i < 3; ++i) {
            for (int ii = 0; ii < 3; ++ii) {
                NBTTagCompound nbt = recipe.grid[i][ii];
                String name = nbt.func_74779_i("item");
                String ore = nbt.func_74779_i("ore");
                if (name != "") {
                    int meta = nbt.func_74762_e("meta");
                    this.inputs.add(Collections.singletonList(new ItemStack(Item.func_111206_d((String)name), 1, meta)));
                    continue;
                }
                if (ore != "") {
                    NonNullList ores = OreDictionary.getOres((String)ore);
                    this.inputs.add((List<ItemStack>)ores);
                    continue;
                }
                this.inputs.add(null);
            }
        }
        this.output = recipe.output;
        this.knowledge = new ItemStack(recipe.requiredSheet);
    }

    public void getIngredients(IIngredients ingredients) {
        List<List<ItemStack>> newInputs = this.inputs;
        newInputs.add(Collections.singletonList(this.knowledge));
        ingredients.setInputLists(ItemStack.class, newInputs);
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }

    public ItemStack getKnowledge() {
        return this.knowledge;
    }
}

