/*
 * Decompiled with CFR 0.152.
 */
package seraphaestus.historicizedmedicine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import seraphaestus.historicizedmedicine.Compat.MainCompatHandler;
import seraphaestus.historicizedmedicine.Config;
import seraphaestus.historicizedmedicine.CraftingTable.Recipe;
import seraphaestus.historicizedmedicine.Effect.EntityUpdate;
import seraphaestus.historicizedmedicine.GUIProxy;
import seraphaestus.historicizedmedicine.HMedicineMod;
import seraphaestus.historicizedmedicine.Item.MilkOverride;
import seraphaestus.historicizedmedicine.Item.RegistryHandler;
import seraphaestus.historicizedmedicine.Mob.MobChangesHandler;
import seraphaestus.historicizedmedicine.Mob.MobSpawns;
import seraphaestus.historicizedmedicine.Mob.ModEntities;
import seraphaestus.historicizedmedicine.Mob.RegisterVillagePieces;
import seraphaestus.historicizedmedicine.OreDictRegister;

public abstract class CommonProxy {
    public static Configuration config;
    private static List<Recipe> customRecipes;

    public static List<Recipe> getCustomRecipes() {
        if (customRecipes.size() == 0) {
            return new ArrayList<Recipe>();
        }
        ArrayList<Recipe> output = new ArrayList<Recipe>();
        for (Recipe r : customRecipes) {
            if (r == null) continue;
            output.add(new Recipe(r));
        }
        return output;
    }

    public void preInit(FMLPreInitializationEvent e) {
        File directory = e.getModConfigurationDirectory();
        config = new Configuration(new File(directory.getPath(), "historicizedMedicine.cfg"));
        Config.readConfig();
        MainCompatHandler.registerTOP();
        RegistryHandler.preInitCommon();
        seraphaestus.historicizedmedicine.Block.RegistryHandler.preInitCommon();
        new ModEntities().preInit();
        RegisterVillagePieces.init();
        if (Config.disableUseOfMilkBuckets) {
            MinecraftForge.EVENT_BUS.register((Object)new MilkOverride());
        }
        MinecraftForge.EVENT_BUS.register((Object)new MobChangesHandler());
        File baseDir = new File(directory.getPath(), "HistoricizedMedicine Recipes");
        try {
            Files.createDirectory(baseDir.toPath(), new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Path exampleFile = new File(baseDir.getPath(), "exampleFile.json").toPath();
            if (!Files.exists(exampleFile, new LinkOption[0])) {
                Files.createFile(exampleFile, new FileAttribute[0]);
                Files.write(exampleFile, "{\r\n  \"result\": {\r\n    \"item\": \"minecraft:diamond\",\r\n\t\"amount\": 1\r\n  },\r\n  \"top3\": {\t//supports the 9 crafting slots, top1, top2, top3, etc.\r\n\t\"item\": \"minecraft:paper\"\r\n  },\r\n  \"mid2\": {\r\n\t\"ore\": \"listAllmeatraw\"\t//ore dictionary entry\r\n  },\r\n  \"low1\": {\r\n\t\"item\": \"minecraft:stone\",\t//metadata (in this case, for granite)\r\n\t\"meta\": 1\r\n  },\r\n  \"knowledge\": \"historicizedmedicine:ebers_papyrus\"\r\n  //must be a valid knowledge sheet from the mod. other items will not work\r\n  //NOTE: comments are not supported in actual recipe files, do not include them.\r\n}".getBytes(), new OpenOption[0]);
            }
        }
        catch (Exception exampleFile) {
            // empty catch block
        }
        File[] recipeJsons = baseDir.listFiles();
        if (recipeJsons != null) {
            for (File recipeJson : recipeJsons) {
                if (recipeJson.getName() == "exampleFile") continue;
                try {
                    String contents = this.readFile(recipeJson.getAbsolutePath());
                    customRecipes.add(Recipe.getFromJson(contents));
                }
                catch (Exception e2) {
                    System.out.println(e2.getLocalizedMessage());
                }
            }
        }
    }

    public void init() {
        this.registerEventHandlers();
        OreDictRegister.initOreDict();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)HMedicineMod.instance, (IGuiHandler)new GUIProxy());
    }

    public void postInit() {
        if (config.hasChanged()) {
            config.save();
        }
    }

    public abstract boolean playerIsInCreativeMode(EntityPlayer var1);

    public abstract boolean isDedicatedServer();

    protected void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new EntityUpdate());
        MinecraftForge.EVENT_BUS.register((Object)new MobSpawns());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        try {
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    static {
        customRecipes = new ArrayList<Recipe>();
    }
}

