/*
 * Decompiled with CFR 0.152.
 */
package seraphaestus.historicizedmedicine.Block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import seraphaestus.historicizedmedicine.Block.BlockBase;
import seraphaestus.historicizedmedicine.Block.BlockDirectional;
import seraphaestus.historicizedmedicine.Block.BlockStatue;
import seraphaestus.historicizedmedicine.CraftingTable.CraftingTableTileEntity;
import seraphaestus.historicizedmedicine.CraftingTable.HMedCraftingTable;
import seraphaestus.historicizedmedicine.Effect.RegisterEffects;
import seraphaestus.historicizedmedicine.Util.Reduce;

public class RegistryHandler {
    public static final String[] statues = new String[]{"statue_nether", "statue_end", "statue_wise"};
    private static final Potion fireRes = Potion.func_188412_a((int)12);
    public static List<BlockBase> blocks;
    private static HMedCraftingTable craftingTable;

    public static void setupBlocks() {
        blocks = new ArrayList<BlockBase>();
        blocks.add(new BlockDirectional("statue_base", Material.field_151576_e, false));
        blocks.add(new BlockStatue("statue_nether", Material.field_151576_e, new PotionEffect[]{new PotionEffect(fireRes, 1200)}, null, null, 0.0f));
        blocks.add(new BlockStatue("statue_end", Material.field_151576_e, null, null, null, 6.0f));
        blocks.add(new BlockStatue("statue_wise", Material.field_151576_e, null, null, new Reduce[]{new Reduce(RegisterEffects.infection, 200), new Reduce(RegisterEffects.pain, 900)}, 0.0f));
        craftingTable = new HMedCraftingTable();
    }

    public static void preInitCommon() {
        if (blocks == null) {
            RegistryHandler.setupBlocks();
        }
        for (BlockBase block : blocks) {
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
            block.init();
        }
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)craftingTable);
        craftingTable.init();
        GameRegistry.registerTileEntity(CraftingTableTileEntity.class, (String)"historicizedmedicine_crafting_table");
    }

    public static void preInitClientOnly() {
        boolean DEFAULT_ITEM_SUBTYPE = false;
        if (blocks == null) {
            RegistryHandler.setupBlocks();
        }
        for (BlockBase block : blocks) {
            ModelResourceLocation blockModelResourceLocation = new ModelResourceLocation("historicizedmedicine:" + block.id, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)blockModelResourceLocation);
        }
        craftingTable.initModel();
    }
}

