/*
 * Decompiled with CFR 0.152.
 */
package seraphaestus.historicizedmedicine.Block;

import java.util.ArrayList;
import java.util.Random;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import seraphaestus.historicizedmedicine.Block.BlockDirectional;
import seraphaestus.historicizedmedicine.Block.ItemBlockBase;
import seraphaestus.historicizedmedicine.Compat.TOPInfoProvider;
import seraphaestus.historicizedmedicine.Config;
import seraphaestus.historicizedmedicine.Util.PotionName;
import seraphaestus.historicizedmedicine.Util.Reduce;

public class BlockStatue
extends BlockDirectional
implements TOPInfoProvider {
    private PotionEffect[] effect;
    private Reduce[] reduce;
    private Potion[] cure;
    private float heal = 0.0f;
    private int lastCooldownSent = 0;

    public BlockStatue(String id, Material materialIn, PotionEffect[] effect, Potion[] cure, Reduce[] reduce, float heal) {
        super(id, materialIn, false);
        this.func_149711_c(8.0f);
        this.func_149752_b(60.0f);
        this.effect = effect;
        this.cure = cure;
        this.reduce = reduce;
        this.heal = heal;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        NBTTagCompound nbt = playerIn.getEntityData();
        int cooldown = nbt.func_74762_e(this.id + "_cooldown");
        if (cooldown != 0) {
            int cooldownSent = cooldown / 20;
            if (this.lastCooldownSent != cooldownSent && playerIn.func_70093_af()) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("The " + this.func_149732_F() + " is on cooldown: " + cooldownSent + " seconds remaining"));
                this.lastCooldownSent = cooldownSent;
            }
            return false;
        }
        nbt.func_74768_a(this.id + "_cooldown", Config.statueCooldown);
        Random rnd = new Random();
        for (int i = 0; i < Config.statueParticleAmount; ++i) {
            float posx = (float)pos.func_177958_n() + rnd.nextFloat();
            float posy = (float)pos.func_177956_o() + rnd.nextFloat();
            float posz = (float)pos.func_177952_p() + rnd.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.SPELL, (double)posx, (double)(posy + 0.5f), (double)posz, 0.0, 0.0, 0.0, null);
        }
        playerIn.func_70691_i(this.heal);
        if (this.effect != null) {
            for (PotionEffect pe : this.effect) {
                playerIn.func_70690_d(new PotionEffect(pe));
            }
        }
        if (this.cure != null) {
            for (Potion p : this.cure) {
                if (playerIn.func_70660_b(p) == null) continue;
                playerIn.func_184596_c(p);
            }
        }
        if (this.reduce != null) {
            for (Reduce r : this.reduce) {
                PotionEffect pe = playerIn.func_70660_b(r.x);
                if (pe == null) continue;
                int dur = pe.func_76459_b();
                playerIn.func_184596_c(r.x);
                if (dur - r.y <= 0) continue;
                playerIn.func_70690_d(new PotionEffect(r.x, dur - r.y));
            }
        }
        return true;
    }

    @Override
    public void registerItemBlock() {
        ArrayList<String> tooltip = null;
        if (Config.canViewEffectsInTooltip) {
            tooltip = new ArrayList<String>();
            if (this.heal > 0.0f) {
                tooltip.add("Heals by " + this.heal / 2.0f + " hearts");
            } else if (this.heal < 0.0f) {
                tooltip.add("Damages by " + this.heal / -2.0f + " hearts");
            }
            if (this.cure != null) {
                for (Potion potion : this.cure) {
                    tooltip.add("Cures " + PotionName.potionName(potion));
                }
            }
            if (this.reduce != null) {
                for (Reduce reduce : this.reduce) {
                    tooltip.add("Reduces " + PotionName.potionName(reduce.x) + " duration by " + (float)reduce.y / 20.0f + " seconds");
                }
            }
            if (this.effect != null) {
                for (PotionEffect potionEffect : this.effect) {
                    tooltip.add("Gives " + PotionName.potionName(potionEffect.func_188419_a()) + " for " + (float)potionEffect.func_76459_b() / 20.0f + " seconds");
                }
            }
        }
        String[] stringArray = tooltip.toArray(new String[tooltip.size()]);
        ForgeRegistries.ITEMS.register(new ItemBlockBase(this, stringArray).setRegistryName(this.id));
    }

    public int getCooldown(EntityPlayer player) {
        NBTTagCompound nbt = player.getEntityData();
        return nbt.func_74762_e(this.id + "_cooldown");
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        int cooldown = this.getCooldown(player);
        if (cooldown != 0) {
            probeInfo.horizontal().text(TextFormatting.GOLD + "Cooldown: " + cooldown / 20);
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-65536))).progress(100 * cooldown / Config.statueCooldown, 100, probeInfo.defaultProgressStyle().suffix("%"));
        } else {
            probeInfo.horizontal().text(TextFormatting.GREEN + "Ready");
        }
        if (player.func_70093_af()) {
            boolean tooltipEmpty = true;
            if (Config.canViewHealAmountInTooltip) {
                if (this.heal > 0.0f) {
                    probeInfo.horizontal().text("Heals " + this.heal / 2.0f + " hearts");
                    tooltipEmpty = false;
                } else if (this.heal < 0.0f) {
                    probeInfo.horizontal().text("Damages by " + this.heal / -2.0f + " hearts");
                    tooltipEmpty = false;
                }
            }
            if (Config.canViewEffectsInTooltip) {
                if (this.cure != null) {
                    for (Potion potion : this.cure) {
                        probeInfo.horizontal().text("Cures " + PotionName.potionName(potion));
                    }
                    tooltipEmpty = false;
                }
                if (this.reduce != null) {
                    for (Reduce reduce : this.reduce) {
                        probeInfo.horizontal().text("Reduces " + PotionName.potionName(reduce.x) + " duration by " + (float)reduce.y / 20.0f + " seconds");
                    }
                    tooltipEmpty = false;
                }
                if (this.effect != null) {
                    for (PotionEffect potionEffect : this.effect) {
                        probeInfo.horizontal().text("Gives " + PotionName.potionName(potionEffect.func_188419_a()) + " for " + (float)potionEffect.func_76459_b() / 20.0f + " seconds");
                    }
                    tooltipEmpty = false;
                }
                if (tooltipEmpty) {
                    probeInfo.horizontal().text("Effect: ???");
                }
            } else {
                probeInfo.horizontal().text("Effect: ???");
            }
        } else {
            probeInfo.horizontal().text("Sneak for more info");
        }
    }
}

