/*
 * Decompiled with CFR 0.152.
 */
package seraphaestus.historicizedmedicine.Animations.MCACommonLibrary.animation;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import seraphaestus.historicizedmedicine.Animations.MCACommonLibrary.IMCAnimatedEntity;
import seraphaestus.historicizedmedicine.Animations.MCACommonLibrary.animation.AnimationHandler;

public class AnimTickHandler {
    private ArrayList<IMCAnimatedEntity> activeEntities = new ArrayList();
    private ArrayList<IMCAnimatedEntity> removableEntities = new ArrayList();

    public AnimTickHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void addEntity(IMCAnimatedEntity entity) {
        this.activeEntities.add(entity);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!this.activeEntities.isEmpty() && event.phase == TickEvent.Phase.START) {
            try {
                for (IMCAnimatedEntity entity : this.activeEntities) {
                    AnimationHandler animHandler = entity.getAnimationHandler();
                    if (animHandler != null) {
                        animHandler.animationsUpdate();
                    }
                    if (!((Entity)entity).field_70128_L) continue;
                    this.removableEntities.add(entity);
                }
                for (IMCAnimatedEntity entity : this.removableEntities) {
                    this.activeEntities.remove(entity);
                }
                this.removableEntities.clear();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (!this.activeEntities.isEmpty() && event.phase == TickEvent.Phase.START) {
            try {
                for (IMCAnimatedEntity entity : this.activeEntities) {
                    AnimationHandler animHandler = entity.getAnimationHandler();
                    if (animHandler != null) {
                        animHandler.animationsUpdate();
                    }
                    if (!((Entity)entity).field_70128_L) continue;
                    this.removableEntities.add(entity);
                }
                for (IMCAnimatedEntity entity : this.removableEntities) {
                    this.activeEntities.remove(entity);
                }
                this.removableEntities.clear();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
    }
}

