/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.AgedDrinksConfig;
import java.util.ArrayList;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.fluids.properties.DrinkableProperty;
import net.dries007.tfc.objects.fluids.properties.FluidWrapper;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AgedRegistry {
    public static Fluid RUM;
    public static Fluid BEER;
    public static Fluid WHISKEY;
    public static Fluid CORN_WHISKEY;
    public static Fluid RYE_WHISKEY;
    public static Fluid VODKA;
    public static Fluid CIDER;
    public static Fluid SAKE;
    private static final ResourceLocation STILL;
    private static final ResourceLocation FLOW;

    public static Fluid createAgedDrink(String name, Potion potion, int duration, int amplifier) {
        Fluid youngFluid = FluidRegistry.getFluid((String)name);
        DrinkableProperty property = player -> {
            player.func_70690_d(new PotionEffect(potion, duration, amplifier, false, false));
            if (AgedDrinksConfig.General.enableDrunkness && Math.random() < 0.25) {
                PotionEffect effect = new PotionEffect(MobEffects.field_76431_k, 1500, 0, false, false);
                effect.setCurativeItems(new ArrayList());
                player.func_70690_d(effect);
            }
        };
        Fluid agedFluid = new Fluid("aged_" + name, STILL, FLOW, youngFluid.getColor()).setRarity(EnumRarity.UNCOMMON);
        FluidWrapper agedFluidWrapper = AgedRegistry.registerFluid(agedFluid).with(DrinkableProperty.DRINKABLE, (Object)property);
        return agedFluid;
    }

    public static BarrelRecipe getRecipeFor(String name) {
        int len = 576000;
        BarrelRecipe br = new BarrelRecipe(IIngredient.of((Fluid)FluidRegistry.getFluid((String)name), (int)1000), IIngredient.of((Item)Items.field_190931_a), new FluidStack(FluidRegistry.getFluid((String)("aged_" + name)), 1000), new ItemStack(Items.field_190931_a), len);
        br.setRegistryName("aged_" + name);
        return br;
    }

    public static FluidWrapper registerFluid(Fluid newFluid) {
        boolean isDefault = FluidRegistry.registerFluid((Fluid)newFluid);
        if (!isDefault) {
            newFluid = FluidRegistry.getFluid((String)newFluid.getName());
        }
        FluidRegistry.addBucketForFluid((Fluid)newFluid);
        FluidWrapper properties = FluidsTFC.getWrapper((Fluid)newFluid);
        return properties;
    }

    public static void registerAgedDrinks(RegistryEvent.Register<BarrelRecipe> event) {
        RUM = AgedRegistry.createAgedDrink("rum", MobEffects.field_76430_j, AgedDrinksConfig.General.jumpBoostTicks, AgedDrinksConfig.General.jumpBoostLevel);
        event.getRegistry().register((IForgeRegistryEntry)AgedRegistry.getRecipeFor("rum"));
        WHISKEY = AgedRegistry.createAgedDrink("whiskey", MobEffects.field_76422_e, AgedDrinksConfig.General.hasteTicks, AgedDrinksConfig.General.hasteLevel);
        event.getRegistry().register((IForgeRegistryEntry)AgedRegistry.getRecipeFor("whiskey"));
        RYE_WHISKEY = AgedRegistry.createAgedDrink("rye_whiskey", MobEffects.field_76422_e, AgedDrinksConfig.General.hasteTicks, AgedDrinksConfig.General.hasteLevel);
        event.getRegistry().register((IForgeRegistryEntry)AgedRegistry.getRecipeFor("rye_whiskey"));
        CORN_WHISKEY = AgedRegistry.createAgedDrink("corn_whiskey", MobEffects.field_76422_e, AgedDrinksConfig.General.hasteTicks, AgedDrinksConfig.General.hasteLevel);
        event.getRegistry().register((IForgeRegistryEntry)AgedRegistry.getRecipeFor("corn_whiskey"));
        VODKA = AgedRegistry.createAgedDrink("vodka", MobEffects.field_76429_m, AgedDrinksConfig.General.resistanceTicks, AgedDrinksConfig.General.resistanceLevel);
        event.getRegistry().register((IForgeRegistryEntry)AgedRegistry.getRecipeFor("vodka"));
        CIDER = AgedRegistry.createAgedDrink("cider", MobEffects.field_76424_c, AgedDrinksConfig.General.speedTicks, AgedDrinksConfig.General.speedLevel);
        event.getRegistry().register((IForgeRegistryEntry)AgedRegistry.getRecipeFor("cider"));
        BEER = AgedRegistry.createAgedDrink("beer", MobEffects.field_76424_c, AgedDrinksConfig.General.speedTicks, AgedDrinksConfig.General.speedLevel);
        event.getRegistry().register((IForgeRegistryEntry)AgedRegistry.getRecipeFor("beer"));
        SAKE = AgedRegistry.createAgedDrink("sake", MobEffects.field_76420_g, AgedDrinksConfig.General.strengthTicks, AgedDrinksConfig.General.strengthLevel);
        event.getRegistry().register((IForgeRegistryEntry)AgedRegistry.getRecipeFor("sake"));
    }

    static {
        STILL = new ResourceLocation("tfc", "blocks/fluid_still");
        FLOW = new ResourceLocation("tfc", "blocks/fluid_flow");
    }
}

