/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.image.renderable;

import java.awt.image.BufferedImage;
import net.blay09.mods.chattweaks.ChatTweaksConfig;
import net.blay09.mods.chattweaks.image.renderable.IChatRenderable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;

public class StaticChatRenderable
implements IChatRenderable {
    private static final float MAX_WIDTH = 128.0f;
    private static final float MAX_HEIGHT = 14.0f;
    private static final float MAX_HEIGHT_SMALL = 8.0f;
    private int textureId = -1;
    protected int width;
    protected int height;
    protected float scale = 1.0f;
    protected BufferedImage loadBuffer;
    protected int minWidthInSpaces = 4;

    protected StaticChatRenderable() {
    }

    public StaticChatRenderable(BufferedImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.calculateScale();
        this.loadBuffer = image;
    }

    protected void calculateScale() {
        float maxHeight;
        float renderWidth = this.width;
        float renderHeight = this.height;
        if (renderWidth > 128.0f) {
            float factor = 128.0f / renderWidth;
            renderWidth *= factor;
            renderHeight *= factor;
        }
        float f = maxHeight = ChatTweaksConfig.smallerEmotes ? 8.0f : 14.0f;
        if (renderHeight > maxHeight) {
            float factor = maxHeight / renderHeight;
            renderWidth *= factor;
            renderHeight *= factor;
        }
        float scaleX = renderWidth / (float)this.width;
        float scaleY = renderHeight / (float)this.height;
        this.scale = Math.min(scaleX, scaleY);
    }

    @Override
    public int getWidthInSpaces() {
        if (this.textureId == -1) {
            return this.minWidthInSpaces;
        }
        return Math.max(this.minWidthInSpaces, (int)Math.ceil((float)this.width * this.scale / (float)Minecraft.func_71410_x().field_71466_p.func_78263_a(' ')));
    }

    @Override
    public int getTextureId() {
        if (this.loadBuffer != null) {
            this.textureId = TextureUtil.func_110987_a((int)TextureUtil.func_110996_a(), (BufferedImage)this.loadBuffer);
            this.loadBuffer = null;
        }
        return this.textureId;
    }

    @Override
    public void disposeTexture() {
        if (this.textureId != -1) {
            TextureUtil.func_147942_a((int)this.textureId);
            this.textureId = -1;
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public int getTexCoordX() {
        return 0;
    }

    @Override
    public int getTexCoordY() {
        return 0;
    }

    @Override
    public int getSheetWidth() {
        return this.width;
    }

    @Override
    public int getSheetHeight() {
        return this.height;
    }
}

