/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.image.renderable;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.balyware.CachedAPI;
import net.blay09.mods.chattweaks.image.renderable.AnimatedChatRenderable;
import net.blay09.mods.chattweaks.image.renderable.IChatRenderable;
import net.blay09.mods.chattweaks.image.renderable.NullRenderable;
import net.blay09.mods.chattweaks.image.renderable.StaticChatRenderable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.NodeList;

public class ImageLoader {
    private static final int MAX_CACHE_TIME = 604800000;

    public static IChatRenderable loadImage(URI uri) throws IOException {
        return ImageLoader.loadImage(uri, (File)null);
    }

    public static IChatRenderable loadImage(URI uri, String saveToFile) throws IOException {
        return ImageLoader.loadImage(uri, new File(CachedAPI.getCacheDirectory(), saveToFile));
    }

    public static IChatRenderable loadImage(URI uri, @Nullable File saveToFile) throws IOException {
        if (saveToFile != null && saveToFile.exists() && saveToFile.lastModified() - System.currentTimeMillis() <= 604800000L) {
            try {
                return ImageLoader.loadImageInternal(new FileInputStream(saveToFile), null);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        } else {
            try (InputStream in = uri.toURL().openStream();){
                IChatRenderable iChatRenderable = ImageLoader.loadImageInternal(in, saveToFile);
                return iChatRenderable;
            }
        }
        return NullRenderable.INSTANCE;
    }

    public static IChatRenderable loadImage(InputStream in) throws IOException {
        return ImageLoader.loadImage(in, (File)null);
    }

    public static IChatRenderable loadImage(InputStream in, String saveToFile) throws IOException {
        return ImageLoader.loadImage(in, new File(CachedAPI.getCacheDirectory(), saveToFile));
    }

    public static IChatRenderable loadImage(InputStream in, @Nullable File saveToFile) throws IOException {
        return ImageLoader.loadImageInternal(in, saveToFile);
    }

    public static IChatRenderable loadImage(ResourceLocation resourceLocation) {
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
            return ImageLoader.loadImageInternal(resource.func_110527_b(), null);
        }
        catch (IOException e) {
            ChatTweaks.logger.error("Failed to load inbuilt image {}: ", (Object)resourceLocation, (Object)e);
            return NullRenderable.INSTANCE;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IChatRenderable loadImageInternal(Object obj, @Nullable File saveToFile) throws IOException {
        boolean cumulativeRendering;
        NodeList childNodes;
        int i;
        BufferedImage[] images;
        int[] offsetY;
        int[] offsetX;
        int[] frameTime;
        ImageOutputStream out;
        ImageWriter writer;
        ImageReader reader;
        try (ImageInputStream in = ImageIO.createImageInputStream(obj);){
            if (in == null) {
                throw new IOException("Failed to load image: input stream is null");
            }
            Iterator<ImageReader> it = ImageIO.getImageReaders(in);
            if (!it.hasNext()) return NullRenderable.INSTANCE;
            reader = it.next();
            reader.setInput(in);
            int numImages = reader.getNumImages(true);
            if (numImages > 1) {
                writer = null;
                out = null;
                if (saveToFile != null) {
                    out = ImageIO.createImageOutputStream(saveToFile);
                    writer = ImageIO.getImageWriter(reader);
                    writer.setOutput(out);
                }
            } else {
                BufferedImage image = reader.read(0);
                if (saveToFile != null) {
                    try (ImageOutputStream out2 = ImageIO.createImageOutputStream(saveToFile);){
                        ImageWriter writer2 = ImageIO.getImageWriter(reader);
                        writer2.setOutput(out2);
                        writer2.write(image);
                    }
                }
                StaticChatRenderable staticChatRenderable = new StaticChatRenderable(image);
                return staticChatRenderable;
            }
            frameTime = new int[numImages];
            offsetX = new int[numImages];
            offsetY = new int[numImages];
            images = new BufferedImage[numImages];
            i = 0;
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        while (true) {
            NodeList childNodes2;
            IIOMetadata metadata;
            if (i < images.length) {
                images[i] = reader.read(reader.getMinIndex() + i);
                metadata = reader.getImageMetadata(i);
                String metaFormatName = metadata.getNativeMetadataFormatName();
                if (metaFormatName == null) {
                    throw new IOException("Failed to load image: meta format name is null");
                }
                IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metaFormatName);
                childNodes2 = root.getChildNodes();
            } else {
                if (out != null) {
                    out.close();
                }
                IIOMetadata metadata2 = reader.getImageMetadata(0);
                String metaFormatName = metadata2.getNativeMetadataFormatName();
                IIOMetadataNode root = (IIOMetadataNode)metadata2.getAsTree(metaFormatName);
                childNodes = root.getChildNodes();
                cumulativeRendering = true;
                break;
            }
            for (int j = 0; j < childNodes2.getLength(); ++j) {
                if (childNodes2.item(j).getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
                    frameTime[i] = Integer.parseInt(((IIOMetadataNode)childNodes2.item(j)).getAttribute("delayTime")) * 10;
                }
                if (!childNodes2.item(j).getNodeName().equalsIgnoreCase("ImageDescriptor")) continue;
                try {
                    offsetX[i] = Integer.parseInt(((IIOMetadataNode)childNodes2.item(j)).getAttribute("imageLeftPosition"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    offsetY[i] = Integer.parseInt(((IIOMetadataNode)childNodes2.item(j)).getAttribute("imageTopPosition"));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (writer != null) {
                ImageReadParam imageReadParam = new ImageReadParam();
                IIOImage ioImage = reader.readAll(i, imageReadParam);
                ImageWriteParam imageWriteParam = new ImageWriteParam(Locale.ENGLISH);
                writer.prepareWriteSequence(metadata);
                writer.writeToSequence(ioImage, imageWriteParam);
            }
            ++i;
        }
        for (int i2 = 0; i2 < childNodes.getLength(); ++i2) {
            if (!childNodes.item(i2).getNodeName().equalsIgnoreCase("GraphicControlExtension")) continue;
            cumulativeRendering = ((IIOMetadataNode)childNodes.item(i2)).getAttribute("disposalMethod").equals("doNotDispose");
            break;
        }
        AnimatedChatRenderable image = new AnimatedChatRenderable(images, frameTime, offsetX, offsetY);
        image.setCumulativeRendering(cumulativeRendering);
        return image;
    }
}

