/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.image.renderable;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import net.blay09.mods.chattweaks.image.renderable.IAnimatedChatRenderable;
import net.blay09.mods.chattweaks.image.renderable.StaticChatRenderable;
import net.minecraft.client.Minecraft;

public class AnimatedChatRenderable
extends StaticChatRenderable
implements IAnimatedChatRenderable {
    private int[] frameTimes;
    private boolean cumulativeRendering;
    private int animationFrames;
    private int spriteSheetWidth;
    private int spriteSheetHeight;
    private int animationTime;
    private int currentFrameTime;
    private int currentFrame;
    private int currentFrameTexCoordX;
    private int currentFrameTexCoordY;
    private long lastRenderTime;

    public AnimatedChatRenderable(BufferedImage[] images, int[] frameTime, int[] offsetX, int[] offsetY) {
        this.frameTimes = frameTime;
        this.width = images[0].getWidth();
        this.height = images[0].getHeight();
        this.animationFrames = images.length;
        this.calculateScale();
        this.spriteSheetWidth = this.width * images.length;
        this.spriteSheetHeight = this.height;
        int maxTextureSize = Minecraft.func_71369_N();
        if (this.spriteSheetWidth > maxTextureSize) {
            int overflowX = maxTextureSize % this.width;
            this.spriteSheetWidth = maxTextureSize - overflowX;
            this.spriteSheetHeight = (int)((double)this.height * (Math.ceil(overflowX / maxTextureSize) + 1.0));
            if (this.spriteSheetHeight > maxTextureSize) {
                this.loadBuffer = images[0];
                return;
            }
        }
        int framesPerX = this.spriteSheetWidth / this.width;
        int framesPerY = this.spriteSheetHeight / this.height;
        this.loadBuffer = new BufferedImage(this.spriteSheetWidth, this.spriteSheetHeight, 2);
        DrawImageCallback callback = new DrawImageCallback();
        Graphics2D g = this.loadBuffer.createGraphics();
        for (int y = 0; y < framesPerY; ++y) {
            for (int x = 0; x < framesPerX; ++x) {
                int frameIdx = x + y * framesPerX;
                if (this.cumulativeRendering && frameIdx > 0) {
                    int prevFrameIdx = frameIdx - 1;
                    int prevFrameX = prevFrameIdx % framesPerX;
                    int prevFrameY = (int)Math.floor((float)prevFrameIdx / (float)framesPerX);
                    int dx = x * this.width - prevFrameX * this.width;
                    int dy = y * this.height - prevFrameY * this.height;
                    g.copyArea(prevFrameX * this.width, prevFrameY * this.height, this.width, this.height, dx, dy);
                }
                callback.prepare();
                if (g.drawImage((Image)images[frameIdx], x * this.width + offsetX[frameIdx], y * this.height + offsetY[frameIdx], callback)) continue;
                while (!callback.isReady()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @Override
    public void updateAnimation() {
        long now = System.currentTimeMillis();
        if (this.lastRenderTime == 0L) {
            this.lastRenderTime = now;
            this.currentFrameTime = this.frameTimes[0];
        }
        this.animationTime = (int)((long)this.animationTime + (now - this.lastRenderTime));
        int lastFrame = this.currentFrame;
        while (this.animationTime > this.currentFrameTime) {
            this.animationTime -= this.currentFrameTime;
            ++this.currentFrame;
            if (this.currentFrame >= this.animationFrames) {
                this.currentFrame = 0;
            }
            this.currentFrameTime = this.frameTimes[this.currentFrame];
        }
        if (this.currentFrame != lastFrame) {
            this.currentFrameTexCoordX = this.currentFrame * this.width;
            this.currentFrameTexCoordY += this.height * (this.currentFrameTexCoordX / this.spriteSheetWidth);
            this.currentFrameTexCoordX %= this.spriteSheetWidth;
        }
        this.lastRenderTime = now;
    }

    @Override
    public int getSheetWidth() {
        return this.spriteSheetWidth;
    }

    @Override
    public int getSheetHeight() {
        return this.spriteSheetHeight;
    }

    @Override
    public int getTexCoordX() {
        return this.currentFrameTexCoordX;
    }

    @Override
    public int getTexCoordY() {
        return this.currentFrameTexCoordY;
    }

    public void setCumulativeRendering(boolean cumulativeRendering) {
        this.cumulativeRendering = cumulativeRendering;
    }

    public boolean isCumulativeRendering() {
        return this.cumulativeRendering;
    }

    private static class DrawImageCallback
    implements ImageObserver {
        private boolean isReady;

        private DrawImageCallback() {
        }

        public void prepare() {
            this.isReady = false;
        }

        @Override
        public boolean imageUpdate(Image img, int infoFlags, int x, int y, int width, int height) {
            if ((infoFlags & 0x20) == 32) {
                this.isReady = true;
            } else if ((infoFlags & 0x80) == 128) {
                this.isReady = true;
            }
            return false;
        }

        public boolean isReady() {
            return this.isReady;
        }
    }
}

