/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.gui.emotes;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.chattweaks.chat.emotes.EmoteRegistry;
import net.blay09.mods.chattweaks.chat.emotes.IEmote;
import net.blay09.mods.chattweaks.chat.emotes.IEmoteGroup;
import net.blay09.mods.chattweaks.gui.emotes.GuiButtonEmote;
import net.blay09.mods.chattweaks.gui.emotes.GuiButtonEmoteGroup;
import net.blay09.mods.chattweaks.image.renderable.IChatRenderable;
import net.blay09.mods.chattweaks.image.renderable.ImageLoader;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;

public class GuiOverlayEmotes {
    private static final String[] BANNED_EMOTES = new String[]{"JKanStyle", "OptimizePrime", "StoneLightning", "TheRinger", "PazPazowitz", "EagleEye", "CougarHunt", "RedCoat", "JonCarnage", "PicoMause", "BCWarrior", "NoNoSpot"};
    private static IChatRenderable iconTwitch;
    private static IChatRenderable iconBTTV;
    private static IChatRenderable iconFFZ;
    private final GuiScreen parentScreen;
    private final int width = 120;
    private final int height = 80;
    private int x;
    private int y;
    private String currentGroup = "TwitchGlobal";
    private final List<GuiButtonEmote> emoteButtons = Lists.newArrayList();
    private int scrollOffset;
    private boolean mouseInside;

    public GuiOverlayEmotes(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
        if (iconTwitch == null) {
            iconTwitch = ImageLoader.loadImage(new ResourceLocation("chattweaks", "groups/twitch.png"));
        }
        if (iconBTTV == null) {
            iconBTTV = ImageLoader.loadImage(new ResourceLocation("chattweaks", "groups/bttv.png"));
        }
        if (iconFFZ == null) {
            iconFFZ = ImageLoader.loadImage(new ResourceLocation("chattweaks", "groups/ffz.png"));
        }
    }

    public void initGui() {
        IEmoteGroup group;
        IEmoteGroup ffzGroup;
        IEmoteGroup bttvGroup;
        this.x = this.parentScreen.field_146294_l - 120 - 2;
        this.y = this.parentScreen.field_146295_m - 80 - 14;
        this.clear();
        int groupX = this.x;
        int groupY = this.y + 2;
        IEmoteGroup twitchGroup = EmoteRegistry.getGroup("TwitchGlobal");
        if (twitchGroup != null) {
            this.parentScreen.field_146292_n.add(new GuiButtonEmoteGroup(-1, groupX, groupY, iconTwitch, twitchGroup));
            groupY += 14;
        }
        if ((bttvGroup = EmoteRegistry.getGroup("BTTV")) != null) {
            this.parentScreen.field_146292_n.add(new GuiButtonEmoteGroup(-1, groupX, groupY, iconBTTV, bttvGroup));
            groupY += 14;
        }
        if ((ffzGroup = EmoteRegistry.getGroup("FFZ")) != null) {
            this.parentScreen.field_146292_n.add(new GuiButtonEmoteGroup(-1, groupX, groupY, iconFFZ, ffzGroup));
            groupY += 14;
        }
        if ((group = EmoteRegistry.getGroup(this.currentGroup)) != null) {
            this.displayGroup(group);
        } else {
            group = EmoteRegistry.getFirstGroup();
            if (group != null) {
                this.displayGroup(group);
            }
        }
    }

    public void actionPerformed(GuiButton button) {
        if (button instanceof GuiButtonEmoteGroup) {
            this.displayGroup(((GuiButtonEmoteGroup)button).getEmoteGroup());
        } else if (button instanceof GuiButtonEmote) {
            ((GuiChat)this.parentScreen).field_146415_a.func_146191_b(" " + ((GuiButtonEmote)button).getEmote().getCode() + " ");
        }
    }

    public void drawOverlay(int mouseX, int mouseY) {
        int index = -1;
        int buttonX = this.x + 16;
        int buttonY = this.y + 2;
        for (GuiButtonEmote button : this.emoteButtons) {
            if (++index >= this.scrollOffset) {
                if (buttonX + button.field_146120_f > this.x + 120 - 2) {
                    buttonX = this.x + 16;
                    buttonY += 18;
                }
                if (buttonY + 18 > this.y + 80 - 2) {
                    button.field_146125_m = false;
                    continue;
                }
                button.field_146128_h = buttonX;
                button.field_146129_i = buttonY;
                button.field_146125_m = true;
                buttonX += button.field_146120_f + 2;
                continue;
            }
            button.field_146125_m = false;
        }
        Gui.func_73734_a((int)(this.x + 14), (int)this.y, (int)(this.x + 120), (int)(this.y + 80), (int)-1442840576);
        this.mouseInside = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + 120 && mouseY < this.y + 80;
    }

    public void displayGroup(IEmoteGroup group) {
        this.clear();
        for (IEmote emote : group.getEmotes()) {
            if (ArrayUtils.contains((Object[])BANNED_EMOTES, (Object)emote.getCode())) continue;
            GuiButtonEmote button = new GuiButtonEmote(-1, this.x, this.y, emote);
            this.emoteButtons.add(button);
            this.parentScreen.field_146292_n.add(button);
        }
        this.currentGroup = group.getName();
    }

    public void mouseScrolled(int delta) {
        int emoteColumns = 4;
        int emoteRows = 5;
        this.scrollOffset = delta > 0 ? Math.max(0, this.scrollOffset - 4) : Math.min(this.emoteButtons.size() - 20 + 4, this.scrollOffset + 4);
    }

    private void clear() {
        this.scrollOffset = 0;
        this.parentScreen.field_146292_n.removeIf(guiButton -> guiButton instanceof GuiButtonEmote);
        this.emoteButtons.clear();
    }

    public void close() {
        this.clear();
        this.parentScreen.field_146292_n.removeIf(p -> p instanceof GuiButtonEmoteGroup);
    }

    public boolean isMouseInside() {
        return this.mouseInside;
    }
}

