/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.gui.config;

import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.balyware.BlayCommon;
import net.blay09.mods.chattweaks.gui.GuiOpenIntegrationLink;
import net.blay09.mods.chattweaks.gui.config.GuiChatViewsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class GuiFactory
implements IModGuiFactory {
    public void initialize(Minecraft mc) {
    }

    public boolean hasConfigGui() {
        return true;
    }

    public GuiScreen createConfigGui(GuiScreen parentScreen) {
        return new ConfigGUI(parentScreen);
    }

    @Nullable
    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return null;
    }

    public static class TwitchIntegrationButtonEntry
    extends GuiConfigEntries.CategoryEntry
    implements GuiYesNoCallback {
        public TwitchIntegrationButtonEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            if (Loader.isModLoaded((String)"twitchintegration")) {
                IModGuiFactory factory = FMLClientHandler.instance().getGuiFactoryFor((ModContainer)Loader.instance().getIndexedModList().get("twitchintegration"));
                return factory.createConfigGui((GuiScreen)this.owningScreen);
            }
            return new GuiOpenIntegrationLink(this, "Twitch", "Chat Tweaks - Twitch Integration", 0, "http://minecraft.curseforge.com/projects/twitch-integration");
        }

        public void func_73878_a(boolean result, int id) {
            if (result) {
                try {
                    BlayCommon.openWebLink(new URI("http://minecraft.curseforge.com/projects/twitch-integration"));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            this.mc.func_147108_a((GuiScreen)this.owningScreen);
        }
    }

    public static class ConfigGUI
    extends GuiConfig {
        public ConfigGUI(GuiScreen parentScreen) {
            super(parentScreen, ConfigGUI.getCategories(), "chattweaks", "config", false, false, "Chat Tweaks Settings");
        }

        private static List<IConfigElement> getCategories() {
            ArrayList list = Lists.newArrayList();
            list.add(new DummyConfigElement.DummyCategoryElement("General", "chattweaks:config.category.general", new ConfigElement(ChatTweaks.getConfig().getCategory("general")).getChildElements()));
            list.add(new DummyConfigElement.DummyCategoryElement("Emotes", "chattweaks:config.category.emotes", new ConfigElement(ChatTweaks.getConfig().getCategory("emotes")).getChildElements()));
            list.add(new DummyConfigElement.DummyCategoryElement("Theme", "chattweaks:config.category.theme", new ConfigElement(ChatTweaks.getConfig().getCategory("theme")).getChildElements()));
            list.add(GuiChatViewsConfig.getDummyElement());
            list.add(new DummyConfigElement.DummyCategoryElement("Twitch Integration", "chattweaks:config.category.twitchintegration", TwitchIntegrationButtonEntry.class));
            return list;
        }
    }
}

