/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.gui.config;

import net.blay09.mods.chattweaks.ChatViewManager;
import net.blay09.mods.chattweaks.chat.ChatView;
import net.blay09.mods.chattweaks.gui.config.GuiButtonSortChatView;
import net.blay09.mods.chattweaks.gui.config.GuiChatView;
import net.blay09.mods.chattweaks.gui.config.SmartyListElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArray;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class GuiChatViewsConfig
extends GuiEditArray {
    public GuiChatViewsConfig(GuiScreen parentScreen, IConfigElement configElement, int slotIndex, Object[] currentValues, boolean enabled) {
        super(parentScreen, configElement, slotIndex, currentValues, enabled);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.entryList = this.createEntryList();
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button == this.btnUndoChanges) {
            this.entryList = this.createEntryList();
        } else if (button == this.btnDefault) {
            this.entryList = this.createEntryList();
        }
    }

    public ChatViewEditArrayEntries createEntryList() {
        return new ChatViewEditArrayEntries(this, this.field_146297_k, this.configElement, this.beforeValues, this.currentValues);
    }

    public void saveAndUpdateList() {
        ((ChatViewEditArrayEntries)this.entryList).saveList();
        this.currentValues = ((GuiConfig)this.parentScreen).entryList.getListEntry(this.slotIndex).getCurrentValues();
    }

    public static IConfigElement getDummyElement() {
        SmartyListElement dummy = new SmartyListElement("Views", ChatViewManager.createDefaults(), ConfigGuiType.STRING, "chattweaks:config.category.views");
        dummy.setConfigEntryClass(ChatViewConfigEntry.class);
        dummy.setArrayEntryClass(ChatViewArrayEntry.class);
        dummy.setCustomEditListEntryClass(ChatViewArrayEntry.class);
        dummy.set(ChatViewManager.getViews().toArray());
        return dummy;
    }

    public static class ChatViewArrayEntry
    extends GuiEditArrayEntries.BaseEntry {
        private final GuiButtonExt button;
        private final ChatView chatView;
        private final GuiButtonSortChatView buttonUp;
        private final GuiButtonSortChatView buttonDown;

        public ChatViewArrayEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Object value) {
            this(owningScreen, owningEntryList, configElement, value, true);
        }

        public ChatViewArrayEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Object value, boolean canDelete) {
            super(owningScreen, owningEntryList, configElement);
            this.btnRemoveEntry.field_146124_l = canDelete;
            this.chatView = value.equals("") ? new ChatView(ChatViewManager.getFreeChatViewName()) : (value instanceof ChatView ? (ChatView)value : null);
            this.button = new GuiButtonExt(0, 0, 0, owningEntryList.controlWidth - 12, 18, I18n.func_135052_a((String)String.valueOf(value), (Object[])new Object[0]));
            this.buttonUp = new GuiButtonSortChatView(1, 0, 0, this, -1);
            this.buttonDown = new GuiButtonSortChatView(1, 0, 0, this, 1);
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            this.btnRemoveEntry.field_146124_l = this.owningEntryList.listEntries.size() > 2;
            this.button.field_146128_h = listWidth / 4 + 12;
            this.button.field_146129_i = y;
            if (this.chatView != null) {
                int warningCount = 0;
                if (this.chatView.getChannels().isEmpty()) {
                    ++warningCount;
                }
                this.button.field_146126_j = this.chatView.getName();
                if (warningCount > 0) {
                    this.button.field_146126_j = this.button.field_146126_j + " " + TextFormatting.RED + I18n.func_135052_a((String)"chattweaks:config.views.warnings", (Object[])new Object[]{warningCount});
                }
                if (this.chatView.isMuted()) {
                    this.button.field_146126_j = this.button.field_146126_j + " " + TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"chattweaks:config.views.muted", (Object[])new Object[0]);
                } else if (warningCount == 0) {
                    this.button.field_146126_j = this.button.field_146126_j + TextFormatting.AQUA + " [" + this.chatView.getMessageStyle().name() + "]";
                }
            } else {
                this.button.field_146126_j = "invalid";
            }
            this.button.func_191745_a(this.owningEntryList.getMC(), mouseX, mouseY, partial);
            if (slotIndex > 0) {
                this.buttonUp.drawButton(this.owningEntryList.getMC(), mouseX, mouseY, x, y, listWidth, slotHeight);
            }
            if (slotIndex < this.owningEntryList.listEntries.size() - 2) {
                this.buttonDown.drawButton(this.owningEntryList.getMC(), mouseX, mouseY, x, y, listWidth, slotHeight);
            }
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.button.func_146116_c(this.owningEntryList.getMC(), x, y)) {
                this.button.func_146113_a(this.owningEntryList.getMC().func_147118_V());
                ((GuiChatViewsConfig)this.owningScreen).saveAndUpdateList();
                this.owningScreen.field_146297_k.func_147108_a((GuiScreen)new GuiChatView((GuiScreen)this.owningScreen, this.chatView));
                return true;
            }
            if (this.buttonUp.func_146116_c(this.owningEntryList.getMC(), x, y)) {
                if (index > 0) {
                    this.owningEntryList.listEntries.set(index, this.owningEntryList.listEntries.get(index - 1));
                    this.owningEntryList.listEntries.set(index - 1, this);
                }
            } else if (this.buttonDown.func_146116_c(this.owningEntryList.getMC(), x, y) && index < this.owningEntryList.listEntries.size() - 2) {
                this.owningEntryList.listEntries.set(index, this.owningEntryList.listEntries.get(index + 1));
                this.owningEntryList.listEntries.set(index + 1, this);
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.button.func_146118_a(x, y);
            super.func_148277_b(index, x, y, mouseEvent, relativeX, relativeY);
        }

        public Object getValue() {
            return this.chatView;
        }
    }

    public static class ChatViewConfigEntry
    extends GuiConfigEntries.ArrayEntry {
        protected final GuiButtonExt btnValueFixed;

        public ChatViewConfigEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.btnValue.field_146125_m = false;
            this.drawLabel = false;
            this.btnValueFixed = new GuiButtonExt(0, 0, 0, 300, 18, I18n.func_135052_a((String)this.name, (Object[])new Object[0]));
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            this.btnValueFixed.field_146128_h = listWidth / 2 - 150;
            this.btnValueFixed.field_146129_i = y;
            this.btnValueFixed.field_146124_l = this.enabled();
            this.btnValueFixed.func_191745_a(this.mc, mouseX, mouseY, partial);
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnValueFixed.func_146116_c(this.mc, x, y)) {
                this.btnValueFixed.func_146113_a(this.mc.func_147118_V());
                this.valueButtonPressed(index);
                this.updateValueButtonText();
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        public void valueButtonPressed(int slotIndex) {
            this.mc.func_147108_a((GuiScreen)new GuiChatViewsConfig((GuiScreen)this.owningScreen, this.configElement, slotIndex, this.currentValues, this.enabled()));
        }

        public boolean saveConfigElement() {
            ChatViewManager.removeAllChatViews();
            for (Object chatView : this.currentValues) {
                ChatViewManager.addChatView((ChatView)chatView);
            }
            return super.saveConfigElement();
        }
    }

    public static class ChatViewEditArrayEntries
    extends GuiEditArrayEntries {
        public ChatViewEditArrayEntries(GuiEditArray parent, Minecraft mc, IConfigElement configElement, Object[] beforeValues, Object[] currentValues) {
            super(parent, mc, configElement, beforeValues, currentValues);
        }

        public void addNewEntry(int index) {
            super.addNewEntry(index);
            ((GuiChatViewsConfig)this.owningGui).saveAndUpdateList();
            ChatViewArrayEntry entry = (ChatViewArrayEntry)((Object)this.listEntries.get(index));
            if (entry.chatView != null) {
                this.field_148161_k.func_147108_a((GuiScreen)new GuiChatView((GuiScreen)this.owningGui, entry.chatView));
            }
        }

        public void saveList() {
            this.saveListChanges();
        }
    }
}

