/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.gui.config;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.blay09.mods.chattweaks.ChatManager;
import net.blay09.mods.chattweaks.chat.ChatChannel;
import net.blay09.mods.chattweaks.gui.config.GuiChannelListEntry;
import net.blay09.mods.chattweaks.gui.config.GuiChatViewChannelsList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArray;
import net.minecraftforge.fml.client.config.IConfigElement;
import org.apache.commons.lang3.ArrayUtils;

public class GuiChatViewChannels
extends GuiEditArray {
    private final List<GuiChannelListEntry> availableChannels = Lists.newArrayList();
    private final List<GuiChannelListEntry> selectedChannels = Lists.newArrayList();
    private GuiChatViewChannelsList listAvailable;
    private GuiChatViewChannelsList listSelected;

    public GuiChatViewChannels(GuiScreen parentScreen, IConfigElement configElement, int slotIndex, Object[] currentValues, boolean enabled) {
        super(parentScreen, configElement, slotIndex, currentValues, enabled);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.updateList();
        this.listAvailable = new GuiChatViewChannelsList(this.field_146297_k, 200, this.field_146295_m, this.availableChannels, I18n.func_135052_a((String)"chattweaks:config.channels.available", (Object[])new Object[0]));
        this.listAvailable.func_148140_g(this.field_146294_l / 2 - 4 - 200);
        this.listAvailable.func_148134_d(7, 8);
        this.listSelected = new GuiChatViewChannelsList(this.field_146297_k, 200, this.field_146295_m, this.selectedChannels, I18n.func_135052_a((String)"chattweaks:config.channels.selected", (Object[])new Object[0]));
        this.listSelected.func_148140_g(this.field_146294_l / 2 + 4);
        this.listSelected.func_148134_d(7, 8);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.listAvailable.func_178039_p();
        this.listSelected.func_178039_p();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.listAvailable.func_148179_a(mouseX, mouseY, mouseButton);
        this.listSelected.func_148179_a(mouseX, mouseY, mouseButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        this.btnDefault.field_146124_l = this.enabled && !this.entryList.isDefault();
        this.btnUndoChanges.field_146124_l = this.enabled && this.entryList.isChanged();
        this.listAvailable.func_148128_a(mouseX, mouseY, partialTicks);
        this.listSelected.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"chattweaks:config.channels.select_channels", (Object[])new Object[0]), this.field_146294_l / 2, 16, 0xFFFFFF);
        for (GuiButton button : this.field_146292_n) {
            button.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
    }

    public boolean isSelected(ChatChannel channel) {
        return ArrayUtils.contains((Object[])this.currentValues, (Object)channel.getName());
    }

    public void unselectChannel(GuiChannelListEntry entry) {
        this.currentValues = ArrayUtils.remove((Object[])this.currentValues, (int)ArrayUtils.indexOf((Object[])this.currentValues, (Object)entry.getName()));
        this.selectedChannels.remove(entry);
        this.availableChannels.add(entry);
        this.recalculateState();
    }

    public void selectChannel(GuiChannelListEntry entry) {
        this.currentValues = ArrayUtils.add((Object[])this.currentValues, (Object)entry.getName());
        this.selectedChannels.add(entry);
        this.availableChannels.remove(entry);
        this.recalculateState();
    }

    public void recalculateState() {
        int i;
        int listLength;
        this.entryList.isDefault = true;
        this.entryList.isChanged = false;
        int n = listLength = this.configElement.isListLengthFixed() ? this.currentValues.length : this.currentValues.length - 1;
        if (listLength != this.configElement.getDefaults().length) {
            this.entryList.isDefault = false;
        }
        if (listLength != this.beforeValues.length) {
            this.entryList.isChanged = true;
        }
        if (this.entryList.isDefault) {
            for (i = 0; i < listLength; ++i) {
                if (this.configElement.getDefaults()[i].equals(this.currentValues[i])) continue;
                this.entryList.isDefault = false;
            }
        }
        if (!this.entryList.isChanged) {
            for (i = 0; i < listLength; ++i) {
                if (this.beforeValues[i].equals(this.currentValues[i])) continue;
                this.entryList.isChanged = true;
            }
        }
    }

    public void updateList() {
        this.selectedChannels.clear();
        this.availableChannels.clear();
        for (ChatChannel chatChannel : ChatManager.getChatChannels()) {
            if (ArrayUtils.contains((Object[])this.currentValues, (Object)chatChannel.getName())) {
                this.selectedChannels.add(new GuiChannelListEntry(this.field_146297_k, this, chatChannel));
                continue;
            }
            this.availableChannels.add(new GuiChannelListEntry(this.field_146297_k, this, chatChannel));
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.btnDone) {
            ((GuiConfigEntries.ArrayEntry)((GuiConfig)this.parentScreen).entryList.getListEntry(this.slotIndex)).setListFromChildScreen(this.currentValues);
            this.field_146297_k.func_147108_a(this.parentScreen);
            return;
        }
        super.func_146284_a(button);
        this.updateList();
    }
}

