/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.gui.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.ChatManager;
import net.blay09.mods.chattweaks.ChatViewManager;
import net.blay09.mods.chattweaks.balyware.gui.FormattedFontRenderer;
import net.blay09.mods.chattweaks.balyware.gui.GuiFormattedTextField;
import net.blay09.mods.chattweaks.balyware.gui.IStringFormatter;
import net.blay09.mods.chattweaks.chat.ChatChannel;
import net.blay09.mods.chattweaks.chat.ChatView;
import net.blay09.mods.chattweaks.chat.MessageStyle;
import net.blay09.mods.chattweaks.gui.config.GuiChatViewChannels;
import net.blay09.mods.chattweaks.gui.config.SmartyConfigElement;
import net.blay09.mods.chattweaks.gui.config.SmartyListElement;
import net.blay09.mods.chattweaks.gui.settings.FormatStringFormatter;
import net.blay09.mods.chattweaks.gui.settings.RegExStringFormatter;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArray;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class GuiChatView
extends GuiConfig {
    private final ChatView chatView;
    private static SmartyConfigElement nameElement;
    private static SmartyConfigElement filterPatternElement;
    private static SmartyConfigElement outputFormatElement;
    private static SmartyConfigElement messageStyleElement;
    private static SmartyConfigElement outgoingPrefixElement;
    private static SmartyConfigElement exclusiveElement;
    private static SmartyConfigElement mutedElement;
    private static SmartyListElement channelListElement;
    private static String[] channelNames;

    public GuiChatView(@Nullable GuiScreen parentScreen, ChatView chatView) {
        super(parentScreen, GuiChatView.getConfigElements(chatView), "chattweaks", "config", false, false, "Manage Chat Views");
        this.chatView = chatView;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 2000) {
            this.entryList.saveConfigElements();
            if (!nameElement.get().equals(this.chatView.getName())) {
                ChatViewManager.renameChatView(this.chatView, (String)nameElement.get());
            }
            this.chatView.setFilterPattern((String)filterPatternElement.get());
            this.chatView.setOutputFormat((String)outputFormatElement.get());
            this.chatView.setMessageStyle(MessageStyle.valueOf((String)messageStyleElement.get()));
            this.chatView.setOutgoingPrefix(!outgoingPrefixElement.get().equals("") ? (String)outgoingPrefixElement.get() : null);
            this.chatView.setExclusive((Boolean)exclusiveElement.get());
            this.chatView.setMuted((Boolean)mutedElement.get());
            this.chatView.setTemporary(false);
            ChatViewManager.save();
            this.field_146297_k.func_147108_a(this.parentScreen);
            return;
        }
        super.func_146284_a(button);
    }

    private static List<IConfigElement> getConfigElements(ChatView chatView) {
        ArrayList list = Lists.newArrayList();
        nameElement = new SmartyConfigElement("Name", chatView.getName(), ConfigGuiType.STRING, "chattweaks:gui.config.view.name");
        list.add(nameElement);
        filterPatternElement = new SmartyConfigElement("Filter Pattern", "", ConfigGuiType.STRING, "chattweaks:gui.config.view.filter_pattern");
        filterPatternElement.set(chatView.getFilterPattern());
        filterPatternElement.setConfigEntryClass(RegexStringEntry.class);
        list.add(filterPatternElement);
        outputFormatElement = new SmartyConfigElement("Output Format", "$0", ConfigGuiType.STRING, "chattweaks:gui.config.view.output_format");
        outputFormatElement.set(chatView.getOutputFormat());
        outputFormatElement.setConfigEntryClass(OutputFormatStringEntry.class);
        list.add(outputFormatElement);
        MessageStyle[] styles = MessageStyle.values();
        String[] styleNames = new String[styles.length];
        for (int i = 0; i < styles.length; ++i) {
            styleNames[i] = styles[i].name();
        }
        messageStyleElement = new SmartyConfigElement("Message Style", (Object)"Chat", ConfigGuiType.STRING, "chattweaks:gui.config.view.message_style", styleNames);
        messageStyleElement.set(chatView.getMessageStyle().name());
        list.add(messageStyleElement);
        outgoingPrefixElement = new SmartyConfigElement("Outgoing Prefix", "", ConfigGuiType.STRING, "chattweaks:gui.config.view.outgoing_prefix");
        outgoingPrefixElement.set(chatView.getOutgoingPrefix() != null ? chatView.getOutgoingPrefix() : "");
        list.add(outgoingPrefixElement);
        exclusiveElement = new SmartyConfigElement("Exclusive", false, ConfigGuiType.BOOLEAN, "chattweaks:gui.config.view.exclusive");
        exclusiveElement.set(chatView.isExclusive());
        list.add(exclusiveElement);
        mutedElement = new SmartyConfigElement("Muted", false, ConfigGuiType.BOOLEAN, "chattweaks:gui.config.view.muted");
        mutedElement.set(chatView.isMuted());
        list.add(mutedElement);
        channelNames = (String[])chatView.getChannels().stream().map(ChatChannel::getName).toArray(String[]::new);
        channelListElement = new SmartyListElement("Channels", (Object[])channelNames, ConfigGuiType.STRING, "chattweaks:gui.config.view.channels", true);
        channelListElement.set(channelNames);
        channelListElement.setConfigEntryClass(ChannelListConfigEntry.class);
        channelListElement.setArrayEntryClass(ChannelListArrayEntry.class);
        channelListElement.setCustomEditListEntryClass(ChannelListArrayEntry.class);
        list.add(channelListElement);
        return list;
    }

    public static class ChannelListConfigEntry
    extends GuiConfigEntries.ArrayEntry {
        public ChannelListConfigEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        public void updateValueButtonText() {
            ChatView chatView = ((GuiChatView)this.owningScreen).chatView;
            if (chatView != null) {
                StringBuilder sb = new StringBuilder();
                for (Object value : this.currentValues) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append((String)value);
                }
                this.btnValue.field_146126_j = sb.length() > 0 ? sb.toString() : TextFormatting.RED + "Warning: No channels selected";
            }
        }

        public void valueButtonPressed(int slotIndex) {
            this.mc.func_147108_a((GuiScreen)new GuiChatViewChannels((GuiScreen)this.owningScreen, this.configElement, slotIndex, this.currentValues, true));
        }

        public boolean saveConfigElement() {
            ((GuiChatView)this.owningScreen).chatView.getChannels().clear();
            for (Object o : this.currentValues) {
                ChatChannel channel = ChatManager.getChatChannel((String)o);
                if (channel == null) continue;
                ((GuiChatView)this.owningScreen).chatView.getChannels().add(channel);
            }
            this.updateValueButtonText();
            return false;
        }
    }

    public static class ChannelListArrayEntry
    extends GuiEditArrayEntries.BaseEntry {
        private final GuiCheckBox checkBox;

        public ChannelListArrayEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Object value) {
            super(owningScreen, owningEntryList, configElement);
            this.checkBox = new GuiCheckBox(0, 0, 0, "", Boolean.parseBoolean((String)value));
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            this.checkBox.field_146128_h = listWidth / 4;
            this.checkBox.field_146129_i = y;
            this.checkBox.field_146126_j = " " + channelNames[slotIndex];
            this.checkBox.func_191745_a(this.owningScreen.field_146297_k, mouseX, mouseY, partial);
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.checkBox.func_146116_c(this.owningEntryList.getMC(), x, y)) {
                this.checkBox.func_146113_a(this.owningEntryList.getMC().func_147118_V());
                this.owningEntryList.recalculateState();
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.checkBox.func_146118_a(x, y);
            super.func_148277_b(index, x, y, mouseEvent, relativeX, relativeY);
        }

        public Object getValue() {
            return this.checkBox.isChecked();
        }
    }

    public static class RegexStringEntry
    extends FormattedStringEntry {
        public RegexStringEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement, new RegExStringFormatter(), "(all messages)");
        }
    }

    public static class OutputFormatStringEntry
    extends FormattedStringEntry {
        public OutputFormatStringEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement, new FormatStringFormatter(), "(original)");
        }
    }

    public static abstract class FormattedStringEntry
    extends GuiConfigEntries.ListEntryBase {
        private final GuiFormattedTextField textField;
        private final String beforeValue;

        public FormattedStringEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement, IStringFormatter formatter, String displayTextWhenEmpty) {
            super(owningScreen, owningEntryList, configElement);
            this.textField = new GuiFormattedTextField(10, new FormattedFontRenderer(this.mc, this.mc.field_71466_p, formatter), owningEntryList.controlX + 1, 0, owningEntryList.controlWidth - 3, 16);
            this.textField.setDisplayTextWhenEmpty(displayTextWhenEmpty);
            this.textField.func_146203_f(10000);
            this.textField.func_146180_a(configElement.get().toString());
            this.beforeValue = configElement.get().toString();
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            this.textField.field_146209_f = this.owningEntryList.controlX + 2;
            this.textField.field_146210_g = y + 1;
            this.textField.field_146218_h = this.owningEntryList.controlWidth - 4;
            this.textField.func_146184_c(this.enabled());
            this.textField.func_146194_f();
        }

        public void keyTyped(char eventChar, int eventKey) {
            if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                this.textField.func_146201_a(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                if (this.configElement.getValidationPattern() != null) {
                    this.isValidValue = this.configElement.getValidationPattern().matcher(this.textField.func_146179_b().trim()).matches();
                }
            }
        }

        public void updateCursorCounter() {
            this.textField.func_146178_a();
        }

        public void mouseClicked(int x, int y, int mouseEvent) {
            this.textField.func_146192_a(x, y, mouseEvent);
        }

        public boolean isDefault() {
            return this.configElement.getDefault() != null ? this.configElement.getDefault().toString().equals(this.textField.func_146179_b()) : this.textField.func_146179_b().trim().isEmpty();
        }

        public void setToDefault() {
            if (this.enabled()) {
                this.textField.func_146180_a(this.configElement.getDefault() != null ? this.configElement.getDefault().toString() : "");
                this.keyTyped('\u0000', 199);
            }
        }

        public boolean isChanged() {
            return this.beforeValue != null ? !this.beforeValue.equals(this.textField.func_146179_b()) : this.textField.func_146179_b().trim().isEmpty();
        }

        public void undoChanges() {
            if (this.enabled()) {
                this.textField.func_146180_a(this.beforeValue);
            }
        }

        public boolean saveConfigElement() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    this.configElement.set((Object)this.textField.func_146179_b());
                    return this.configElement.requiresMcRestart();
                }
                if (this.isChanged() && !this.isValidValue) {
                    this.configElement.setToDefault();
                    return this.configElement.requiresMcRestart() && this.beforeValue != null ? this.beforeValue.equals(this.configElement.getDefault()) : this.configElement.getDefault() == null;
                }
            }
            return false;
        }

        public Object getCurrentValue() {
            return this.textField.func_146179_b();
        }

        public Object[] getCurrentValues() {
            return new Object[]{this.getCurrentValue()};
        }
    }
}

