/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.gui.chat;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.ChatManager;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.ChatTweaksConfig;
import net.blay09.mods.chattweaks.ChatViewManager;
import net.blay09.mods.chattweaks.chat.ChatChannel;
import net.blay09.mods.chattweaks.chat.ChatMessage;
import net.blay09.mods.chattweaks.chat.ChatView;
import net.blay09.mods.chattweaks.chat.MessageStyle;
import net.blay09.mods.chattweaks.chat.TextRenderRegion;
import net.blay09.mods.chattweaks.chat.emotes.EmoteRegistry;
import net.blay09.mods.chattweaks.event.PrintChatMessageEvent;
import net.blay09.mods.chattweaks.image.ChatImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GuiNewChatExt
extends GuiNewChat {
    private static final Pattern FORMATTING_CODE_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR#]");
    private static final Pattern UNDERLINE_CODE_PATTERN = Pattern.compile("(?i)\u00a7n");
    private static final Pattern EMOTE_PATTERN = Pattern.compile("\u00a7\\*");
    private static final Pattern CUSTOM_FORMATTING_CODE_PATTERN = Pattern.compile("\u00a7([#*])");
    private final Minecraft mc;
    private final List<WrappedChatLine> wrappedChatLines = Lists.newArrayList();
    private FontRenderer fontRenderer;
    private boolean alternateBackground;

    public GuiNewChatExt(Minecraft mc) {
        super(mc);
        this.mc = mc;
        this.fontRenderer = mc.field_71466_p;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_146234_a(ITextComponent chatComponent, int chatLineId) {
        if (chatLineId == 0) {
            chatLineId = ChatManager.getNextMessageId();
        }
        ChatMessage message = new ChatMessage(chatLineId, chatComponent);
        this.addChatMessage(message, ChatManager.findChatChannel(message));
    }

    public void addChatMessage(ChatMessage message, ChatChannel channel) {
        channel.addChatMessage(message);
        List<ChatView> views = ChatViewManager.findChatViews(message, channel);
        boolean hasReadMessage = views.contains(ChatViewManager.getActiveView());
        for (ChatView view : views) {
            ChatMessage viewMessage = view.addChatLine(message);
            if (!hasReadMessage && view.getMessageStyle() == MessageStyle.Chat) {
                view.markAsUnread(true);
            }
            this.addChatMessageForDisplay(viewMessage, view);
        }
    }

    private void addChatMessageForDisplay(ChatMessage chatMessage, ChatView view) {
        MinecraftForge.EVENT_BUS.post((Event)new PrintChatMessageEvent(chatMessage, view));
        switch (view.getMessageStyle()) {
            case Chat: {
                if (view != ChatViewManager.getActiveView()) {
                    return;
                }
                int chatWidth = MathHelper.func_76141_d((float)((float)this.func_146228_f() / this.func_146244_h()));
                List wrappedList = GuiUtilRenderComponents.func_178908_a((ITextComponent)chatMessage.getTextComponent(), (int)chatWidth, (FontRenderer)this.mc.field_71466_p, (boolean)false, (boolean)false);
                boolean isChatOpen = this.func_146241_e();
                int colorIndex = -1;
                int emoteIndex = 0;
                for (ITextComponent chatLine : wrappedList) {
                    if (isChatOpen && this.field_146250_j > 0) {
                        this.field_146251_k = true;
                        this.func_146229_b(1);
                    }
                    String formattedText = chatLine.func_150254_d();
                    if (ChatTweaksConfig.disableUnderlines) {
                        formattedText = UNDERLINE_CODE_PATTERN.matcher(formattedText).replaceAll("");
                    }
                    Matcher splitMatcher = CUSTOM_FORMATTING_CODE_PATTERN.matcher(formattedText);
                    ArrayList regions = Lists.newArrayList();
                    int lastIdx = 0;
                    while (splitMatcher.find()) {
                        String code = splitMatcher.group(1);
                        regions.add(new TextRenderRegion(formattedText.substring(lastIdx, splitMatcher.start()), chatMessage.getRGBColor(colorIndex)));
                        if (code.equals("#")) {
                            ++colorIndex;
                        }
                        lastIdx = splitMatcher.end();
                    }
                    if (lastIdx < formattedText.length()) {
                        regions.add(new TextRenderRegion(formattedText.substring(lastIdx), chatMessage.getRGBColor(colorIndex)));
                    }
                    String cleanText = FORMATTING_CODE_PATTERN.matcher(chatLine.func_150260_c()).replaceAll("");
                    Matcher matcher = EMOTE_PATTERN.matcher(cleanText);
                    ArrayList images = null;
                    if (chatMessage.hasImages()) {
                        images = Lists.newArrayList();
                        while (matcher.find()) {
                            ChatImage image = chatMessage.getImage(emoteIndex);
                            if (image != null) {
                                image.setIndex(matcher.start());
                                images.add(image);
                            }
                            ++emoteIndex;
                        }
                    }
                    this.wrappedChatLines.add(0, new WrappedChatLine(this.mc.field_71456_v.func_73834_c(), chatMessage, chatLine, cleanText, regions, images, this.alternateBackground));
                }
                while (this.wrappedChatLines.size() > 100) {
                    this.wrappedChatLines.remove(this.wrappedChatLines.size() - 1);
                }
                this.alternateBackground = !this.alternateBackground;
                break;
            }
            case Side: {
                if (view.isMuted()) break;
                ChatTweaks.getSideChatHandler().addMessage(chatMessage);
                break;
            }
            case Bottom: {
                if (view.isMuted()) break;
                ChatTweaks.getBottomChatHandler().setMessage(chatMessage);
            }
        }
    }

    public void func_146231_a(boolean clearSent) {
        this.wrappedChatLines.clear();
        for (ChatChannel channel : ChatManager.getChatChannels()) {
            channel.clearChatMessages();
        }
        if (clearSent) {
            this.func_146238_c().clear();
        }
    }

    public void func_146245_b() {
        this.wrappedChatLines.clear();
        this.func_146240_d();
        ChatView activeView = ChatViewManager.getActiveView();
        if (activeView.getMessageStyle() == MessageStyle.Chat) {
            for (ChatMessage chatMessage : activeView.getChatLines()) {
                this.addChatMessageForDisplay(chatMessage, activeView);
            }
        }
    }

    public void func_146230_a(int updateCounter) {
        EmoteRegistry.runDisposal();
        boolean isChatOpen = this.func_146241_e();
        if (this.mc.field_71474_y.field_74343_n != EntityPlayer.EnumChatVisibility.HIDDEN) {
            int lineSpacing = ChatTweaksConfig.lineSpacing;
            float chatOpacity = this.mc.field_71474_y.field_74357_r * 0.9f + 0.1f;
            int wrappedChatLinesCount = this.wrappedChatLines.size();
            if (wrappedChatLinesCount > 0) {
                float chatScale = this.func_146244_h();
                int chatWidth = MathHelper.func_76123_f((float)((float)this.func_146228_f() / chatScale));
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)2.0f, (float)8.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)chatScale, (float)chatScale, (float)1.0f);
                int maxVisibleLines = this.func_146232_i();
                int drawnLinesCount = 0;
                for (int lineIdx = 0; lineIdx + this.field_146250_j < this.wrappedChatLines.size() && lineIdx < maxVisibleLines; ++lineIdx) {
                    int scaledAlpha;
                    WrappedChatLine chatLine = this.wrappedChatLines.get(lineIdx + this.field_146250_j);
                    int lifeTime = updateCounter - chatLine.timeCreated;
                    if (lifeTime >= 200 && !isChatOpen) continue;
                    int alpha = 255;
                    if (!isChatOpen) {
                        float percentage = (1.0f - (float)lifeTime / 200.0f) * 10.0f;
                        percentage = MathHelper.func_76131_a((float)percentage, (float)0.0f, (float)1.0f);
                        percentage *= percentage;
                        alpha = (int)(255.0f * percentage);
                    }
                    if ((scaledAlpha = (int)((float)alpha * chatOpacity)) > 3) {
                        int x = 0;
                        int y = -lineIdx * (this.fontRenderer.field_78288_b + lineSpacing);
                        if (chatLine.message.hasBackgroundColor()) {
                            GuiNewChatExt.func_73734_a((int)-2, (int)(y - this.fontRenderer.field_78288_b + lineSpacing / 2), (int)(chatWidth + 4), (int)(y + (int)Math.ceil((float)lineSpacing / 2.0f)), (int)((chatLine.message.getBackgroundColor() & 0xFFFFFF) + (scaledAlpha / 2 << 24)));
                        } else {
                            GuiNewChatExt.func_73734_a((int)-2, (int)(y - this.fontRenderer.field_78288_b - lineSpacing / 2), (int)(chatWidth + 4), (int)(y + (int)Math.ceil((float)lineSpacing / 2.0f)), (int)(((!ChatTweaksConfig.alternateBackground || !chatLine.alternateBackground ? ChatTweaksConfig.backgroundColor1 : ChatTweaksConfig.backgroundColor2) & 0xFFFFFF) + (scaledAlpha / 2 << 24)));
                        }
                        GlStateManager.func_179147_l();
                        for (TextRenderRegion region : chatLine.regions) {
                            x = this.fontRenderer.func_175065_a(region.getText(), (float)x, (float)(y - this.fontRenderer.field_78288_b + 1), (region.getColor() & 0xFFFFFF) + ((ChatTweaksConfig.chatTextOpacity ? alpha : scaledAlpha) << 24), true);
                        }
                        if (chatLine.images != null) {
                            for (ChatImage image : chatLine.images) {
                                int spaceWidth = Minecraft.func_71410_x().field_71466_p.func_78263_a(' ') * image.getSpaces();
                                float scale = image.getScale();
                                int renderOffset = this.fontRenderer.func_78256_a(chatLine.cleanText.substring(0, image.getIndex()));
                                int renderWidth = (int)((float)image.getWidth() * scale);
                                int renderHeight = (int)((float)image.getHeight() * scale);
                                int renderX = renderOffset + spaceWidth / 2 - renderWidth / 2;
                                int renderY = y - Minecraft.func_71410_x().field_71466_p.field_78288_b / 2 - renderHeight / 2;
                                GlStateManager.func_179094_E();
                                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                                image.draw((int)((float)renderX / scale), (int)((float)renderY / scale), scaledAlpha);
                                GlStateManager.func_179121_F();
                            }
                        }
                        GlStateManager.func_179118_c();
                        GlStateManager.func_179084_k();
                    }
                    ++drawnLinesCount;
                }
                if (isChatOpen) {
                    GlStateManager.func_179109_b((float)-3.0f, (float)0.0f, (float)0.0f);
                    int fullHeight = wrappedChatLinesCount * this.fontRenderer.field_78288_b + wrappedChatLinesCount;
                    int drawnHeight = drawnLinesCount * this.fontRenderer.field_78288_b + drawnLinesCount;
                    int scrollY = this.field_146250_j * drawnHeight / wrappedChatLinesCount;
                    int scrollHeight = drawnHeight * drawnHeight / fullHeight;
                    if (fullHeight != drawnHeight) {
                        int alpha = scrollY > 0 ? 170 : 96;
                        int color = this.field_146251_k ? 0xCC3333 : 0x3333AA;
                        GuiNewChatExt.func_73734_a((int)0, (int)(-scrollY), (int)2, (int)(-scrollY - scrollHeight), (int)(color + (alpha << 24)));
                        GuiNewChatExt.func_73734_a((int)2, (int)(-scrollY), (int)1, (int)(-scrollY - scrollHeight), (int)(0xCCCCCC + (alpha << 24)));
                    }
                }
                GlStateManager.func_179121_F();
            }
        }
        if (!isChatOpen && ChatTweaksConfig.showNewMessageOverlay && ChatViewManager.getViews().size() > 1) {
            int x = 2;
            int y = 24;
            for (ChatView chatView : ChatViewManager.getViews()) {
                if (chatView.getMessageStyle() != MessageStyle.Chat) continue;
                String label = "[" + chatView.getName() + "]";
                if (chatView.hasUnreadMessages() && !chatView.isMuted()) {
                    this.mc.field_71466_p.func_175063_a(label, (float)x, (float)y, -65536);
                }
                x += this.mc.field_71466_p.func_78256_a(label) + 2;
            }
        }
    }

    @Nullable
    public ITextComponent func_146236_a(int mouseX, int mouseY) {
        if (!this.func_146241_e()) {
            return null;
        }
        ScaledResolution resolution = new ScaledResolution(this.mc);
        int scaleFactor = resolution.func_78325_e();
        float chatScale = this.func_146244_h();
        int x = mouseX / scaleFactor - 2;
        int y = mouseY / scaleFactor - 40;
        x = MathHelper.func_76141_d((float)((float)x / chatScale));
        y = MathHelper.func_76141_d((float)((float)y / chatScale));
        if (x >= 0 && y >= 0) {
            int clickedIndex;
            int lineCount = Math.min(this.func_146232_i(), this.wrappedChatLines.size());
            if (x <= MathHelper.func_76141_d((float)((float)this.func_146228_f() / this.func_146244_h())) && y < (this.fontRenderer.field_78288_b + ChatTweaksConfig.lineSpacing) * lineCount + lineCount && (clickedIndex = y / (this.fontRenderer.field_78288_b + ChatTweaksConfig.lineSpacing) + this.field_146250_j) >= 0 && clickedIndex < this.wrappedChatLines.size()) {
                WrappedChatLine chatLine = this.wrappedChatLines.get(clickedIndex);
                int width = 0;
                for (ITextComponent component : chatLine.component) {
                    if (!(component instanceof TextComponentString) || (width += this.fontRenderer.func_78256_a(GuiUtilRenderComponents.func_178909_a((String)((TextComponentString)component).func_150265_g(), (boolean)false))) <= x) continue;
                    return component;
                }
            }
        }
        return null;
    }

    public void func_146229_b(int amount) {
        this.field_146250_j = Math.max(Math.min(this.field_146250_j + amount, this.wrappedChatLines.size() - this.func_146232_i()), 0);
        if (this.field_146250_j == 0) {
            this.field_146251_k = false;
        }
    }

    public static class WrappedChatLine {
        private final int timeCreated;
        private final ChatMessage message;
        private final ITextComponent component;
        private final String cleanText;
        private final List<TextRenderRegion> regions;
        private final List<ChatImage> images;
        private final boolean alternateBackground;

        public WrappedChatLine(int timeCreated, ChatMessage message, ITextComponent component, String cleanText, List<TextRenderRegion> regions, @Nullable List<ChatImage> images, boolean alternateBackground) {
            this.timeCreated = timeCreated;
            this.message = message;
            this.component = component;
            this.cleanText = cleanText;
            this.regions = regions;
            this.images = images;
            this.alternateBackground = alternateBackground;
        }
    }
}

