/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.gui.chat;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.balyware.BlayCommon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;

public class GuiImagePreview
extends GuiScreen {
    private static final int IMAGE_WIDTH = 300;
    private static final int IMAGE_HEIGHT = 150;
    private final URL url;
    private final URL directURL;
    private final GuiScreen parentScreen;
    private int textureId = -1;
    private BufferedImage loadBuffer;
    private float textureWidth;
    private float textureHeight;

    public GuiImagePreview(@Nullable GuiScreen parentScreen, URL url, URL directURL) {
        this.parentScreen = parentScreen;
        this.url = url;
        this.directURL = directURL;
    }

    public void func_73866_w_() {
        if (this.textureId == -1) {
            new Thread(() -> {
                try {
                    this.loadBuffer = ImageIO.read(this.directURL);
                }
                catch (IOException e) {
                    ChatTweaks.logger.error("An error occurred trying to load the image preview: ", (Throwable)e);
                }
            }).start();
        }
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 150, this.field_146295_m / 2 + 65, 90, 20, I18n.func_135052_a((String)"chattweaks:gui.imagePreview.openInBrowser", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 50, this.field_146295_m / 2 + 65, 100, 20, I18n.func_135052_a((String)"chattweaks:gui.imagePreview.copyToClipboard", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 + 60, this.field_146295_m / 2 + 65, 90, 20, I18n.func_135052_a((String)"chattweaks:gui.imagePreview.close", (Object[])new Object[0])));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                try {
                    BlayCommon.openWebLink(this.url.toURI());
                }
                catch (URISyntaxException e) {
                    ChatTweaks.logger.error("An error occurred trying to open the link: ", (Throwable)e);
                }
                Minecraft.func_71410_x().func_147108_a(this.parentScreen);
                break;
            }
            case 1: {
                GuiImagePreview.func_146275_d((String)this.url.toString());
                Minecraft.func_71410_x().func_147108_a(this.parentScreen);
                break;
            }
            case 2: {
                Minecraft.func_71410_x().func_147108_a(this.parentScreen);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146270_b(0);
        if (this.textureId == -1 && this.loadBuffer != null) {
            this.textureWidth = this.loadBuffer.getWidth();
            this.textureHeight = this.loadBuffer.getHeight();
            this.textureId = TextureUtil.func_110996_a();
            TextureUtil.func_110987_a((int)this.textureId, (BufferedImage)this.loadBuffer);
            this.loadBuffer = null;
        }
        if (this.textureId == -1) {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"chattweaks:gui.imagePreview.loadingPreview", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 20, -1);
        } else {
            float factor;
            float renderWidth = this.textureWidth;
            float renderHeight = this.textureHeight;
            if (renderWidth > 300.0f) {
                factor = 300.0f / renderWidth;
                renderWidth *= factor;
                renderHeight *= factor;
            }
            if (renderHeight > 150.0f) {
                factor = 150.0f / renderHeight;
                renderWidth *= factor;
                renderHeight *= factor;
            }
            float renderX = (float)(this.field_146294_l / 2) - renderWidth / 2.0f;
            float renderY = (float)(this.field_146295_m / 2) - renderHeight / 2.0f - 20.0f;
            GlStateManager.func_179144_i((int)this.textureId);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)renderX, (double)(renderY + renderHeight), (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(renderX + renderWidth), (double)(renderY + renderHeight), (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(renderX + renderWidth), (double)renderY, (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)renderX, (double)renderY, (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146281_b() {
        if (this.textureId != -1) {
            TextureUtil.func_147942_a((int)this.textureId);
            this.textureId = -1;
        }
    }
}

