/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.gui.chat;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.ChatTweaksConfig;
import net.blay09.mods.chattweaks.ChatViewManager;
import net.blay09.mods.chattweaks.chat.ChatView;
import net.blay09.mods.chattweaks.chat.MessageStyle;
import net.blay09.mods.chattweaks.event.ChatComponentClickEvent;
import net.blay09.mods.chattweaks.event.ChatComponentHoverEvent;
import net.blay09.mods.chattweaks.event.ClientChatEvent;
import net.blay09.mods.chattweaks.event.TabCompletionEvent;
import net.blay09.mods.chattweaks.gui.chat.GuiButtonChatView;
import net.blay09.mods.chattweaks.gui.chat.GuiButtonSettings;
import net.blay09.mods.chattweaks.gui.chat.GuiImagePreview;
import net.blay09.mods.chattweaks.gui.config.GuiChatView;
import net.blay09.mods.chattweaks.gui.config.GuiFactory;
import net.blay09.mods.chattweaks.gui.emotes.GuiButtonEmotes;
import net.blay09.mods.chattweaks.gui.emotes.GuiOverlayEmotes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiChatExt
extends GuiChat {
    private GuiOverlayEmotes emoteMenu;

    public GuiChatExt(String defaultText) {
        super(defaultText);
    }

    public void func_73866_w_() {
        String oldText = this.field_146415_a != null ? this.field_146415_a.func_146179_b() : null;
        super.func_73866_w_();
        this.field_146415_a.field_146218_h -= 36;
        if (!Strings.isNullOrEmpty((String)oldText)) {
            this.field_146415_a.func_146180_a(oldText);
        }
        this.field_146292_n.add(new GuiButtonSettings(0, this.field_146294_l - 16, this.field_146295_m - 14));
        if (!ChatTweaksConfig.hideEmotesMenu) {
            this.field_146292_n.add(new GuiButtonEmotes(0, this.field_146294_l - 30, this.field_146295_m - 14));
        }
        if (this.emoteMenu != null) {
            this.emoteMenu.initGui();
        }
        this.updateChannelButtons();
    }

    public void updateChannelButtons() {
        this.field_146292_n.removeIf(p -> p instanceof GuiButtonChatView);
        if (ChatViewManager.getViews().size() > 1) {
            int x = 2;
            int y = this.field_146295_m - 25;
            for (ChatView chatView : ChatViewManager.getViews()) {
                if (chatView.getMessageStyle() != MessageStyle.Chat) continue;
                GuiButtonChatView btnChatView = new GuiButtonChatView(-1, x, y, Minecraft.func_71410_x().field_71466_p, chatView);
                this.field_146292_n.add(btnChatView);
                x += btnChatView.field_146120_f + 2;
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof GuiButtonSettings) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiChatView(null, ChatViewManager.getActiveView()));
            } else {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiFactory.ConfigGUI((GuiScreen)this));
            }
        } else if (button instanceof GuiButtonChatView) {
            ChatViewManager.setActiveView(((GuiButtonChatView)button).getView());
        } else if (button instanceof GuiButtonEmotes) {
            if (this.emoteMenu == null) {
                this.emoteMenu = new GuiOverlayEmotes((GuiScreen)this);
                this.emoteMenu.initGui();
            } else {
                this.emoteMenu.close();
                this.emoteMenu = null;
            }
        } else if (this.emoteMenu != null) {
            this.emoteMenu.actionPerformed(button);
        }
    }

    public void func_175281_b(String message, boolean addToSentMessages) {
        String newMessage;
        ClientChatEvent event = new ClientChatEvent(message);
        if (ChatViewManager.getActiveView().getOutgoingPrefix() != null && (!event.getMessage().startsWith("/") || event.getMessage().startsWith("/me "))) {
            event.setMessage(ChatViewManager.getActiveView().getOutgoingPrefix() + event.getMessage());
        }
        if (!Strings.isNullOrEmpty((String)(newMessage = MinecraftForge.EVENT_BUS.post((Event)event) ? null : event.getMessage()))) {
            if (addToSentMessages) {
                this.field_146297_k.field_71456_v.func_146158_b().func_146239_a(message);
            }
            super.func_175281_b(newMessage, false);
        }
    }

    public void func_146274_d() throws IOException {
        int delta;
        if (this.emoteMenu != null && this.emoteMenu.isMouseInside() && (delta = Mouse.getEventDWheel()) != 0) {
            delta = MathHelper.func_76125_a((int)delta, (int)-1, (int)1);
            if (!GuiChatExt.func_146272_n()) {
                delta *= 7;
            }
            this.emoteMenu.mouseScrolled(delta);
            return;
        }
        super.func_146274_d();
    }

    public void func_146282_l() throws IOException {
        if (Keyboard.getEventKeyState() && ChatTweaks.keySwitchChatView.isActiveAndMatches(Keyboard.getEventKey())) {
            ChatViewManager.setActiveView(ChatViewManager.getNextChatView(ChatViewManager.getActiveView(), ChatTweaksConfig.preferNewMessages));
        } else {
            super.func_146282_l();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.emoteMenu != null) {
            this.emoteMenu.drawOverlay(mouseX, mouseY);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_184072_a(String ... newCompletions) {
        String input = this.field_146415_a.func_146179_b().substring(0, this.field_146415_a.func_146198_h());
        BlockPos pos = this.field_184096_i.func_186839_b();
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, newCompletions);
        MinecraftForge.EVENT_BUS.post((Event)new TabCompletionEvent(Side.CLIENT, (ICommandSender)Minecraft.func_71410_x().field_71439_g, input.split(" ")[0], pos, pos != null, list));
        super.func_184072_a(list.toArray(new String[0]));
    }

    protected void func_175272_a(ITextComponent component, int x, int y) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new ChatComponentHoverEvent(component, x, y))) {
            super.func_175272_a(component, x, y);
        }
    }

    public boolean func_175276_a(ITextComponent component) {
        if (component != null) {
            if (MinecraftForge.EVENT_BUS.post((Event)new ChatComponentClickEvent(component))) {
                return true;
            }
            ClickEvent clickEvent = component.func_150256_b().func_150235_h();
            if (clickEvent != null && clickEvent.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                Function<String, String> function;
                String url = clickEvent.func_150668_b();
                String directURL = null;
                Iterator<Function<String, String>> iterator = ChatTweaks.getImageURLTransformers().iterator();
                while (iterator.hasNext() && (directURL = (function = iterator.next()).apply(url)) == null) {
                }
                if (directURL != null) {
                    try {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiImagePreview(Minecraft.func_71410_x().field_71462_r, new URL(url), new URL(directURL)));
                        return true;
                    }
                    catch (MalformedURLException e) {
                        ChatTweaks.logger.error("Could not open image preview: ", (Throwable)e);
                    }
                }
            }
        }
        return super.func_175276_a(component);
    }
}

