/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.gui;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.blay09.mods.chattweaks.chat.ChatMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SideChatRenderer {
    private static final int MAX_MESSAGES = 10;
    private static final float MESSAGE_TIME = 120.0f;
    private static final float SCALE = 0.5f;
    private final List<SideChatMessage> messages = Lists.newArrayList();

    public void addMessage(ChatMessage chatMessage) {
        Iterator<SideChatMessage> iterator = this.messages.iterator();
        while (iterator.hasNext()) {
            SideChatMessage message;
            SideChatMessage sideChatMessage = message = iterator.next();
            sideChatMessage.y = sideChatMessage.y - (Minecraft.func_71410_x().field_71466_p.field_78288_b + 2);
        }
        this.messages.add(new SideChatMessage(chatMessage, 0, 120.0f));
        if (this.messages.size() > 10) {
            this.messages.remove(0);
        }
    }

    @SubscribeEvent
    public void onDrawOverlayChat(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || this.messages.isEmpty()) {
            return;
        }
        int height = 64;
        int guiTop = event.getResolution().func_78328_b() - 64;
        int guiLeft = event.getResolution().func_78326_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)guiLeft, (float)guiTop, (float)0.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager.func_179147_l();
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            SideChatMessage message;
            SideChatMessage sideChatMessage = message = this.messages.get(i);
            sideChatMessage.timeLeft = sideChatMessage.timeLeft - event.getPartialTicks();
            int alpha = 255;
            if (message.timeLeft < 24.0f) {
                alpha = (int)Math.max(11.0f, 255.0f * (message.timeLeft / 24.0f));
            }
            if (message.timeLeft <= 0.0f) {
                this.messages.remove(i);
            }
            String formattedText = message.chatMessage.getTextComponent().func_150254_d();
            Minecraft.func_71410_x().field_71466_p.func_175065_a(formattedText, (float)(-Minecraft.func_71410_x().field_71466_p.func_78256_a(formattedText) - 16), (float)message.y, 0xFFFFFF + (alpha << 24), true);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static class SideChatMessage {
        private final ChatMessage chatMessage;
        private int y;
        private float timeLeft;

        public SideChatMessage(ChatMessage chatMessage, int y, float timeLeft) {
            this.chatMessage = chatMessage;
            this.y = y;
            this.timeLeft = timeLeft;
        }
    }
}

