/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.chat.emotes.twitch;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.blay09.mods.chattweaks.ChatTweaksAPI;
import net.blay09.mods.chattweaks.chat.emotes.EmoteRegistry;
import net.blay09.mods.chattweaks.chat.emotes.IEmote;
import net.blay09.mods.chattweaks.chat.emotes.IEmoteGroup;
import net.blay09.mods.chattweaks.chat.emotes.twitch.TwitchChannelEmoteData;
import net.blay09.mods.chattweaks.chat.emotes.twitch.TwitchChannelEmoteSource;
import net.blay09.mods.chattweaks.chat.emotes.twitch.TwitchEmotesAPI;

public class TwitchSubscriberEmotes {
    private static final Pattern DEFAULT_VALIDATION_PATTERN = Pattern.compile("[a-z0-9][a-z0-9]+[A-Z0-9].*");

    public TwitchSubscriberEmotes(String validationRegex) {
        JsonObject root = TwitchEmotesAPI.loadEmotes(new int[0]);
        if (root != null) {
            Pattern validationPattern;
            try {
                validationPattern = Pattern.compile(validationRegex);
            }
            catch (PatternSyntaxException e) {
                validationPattern = DEFAULT_VALIDATION_PATTERN;
            }
            HashMap groupMap = Maps.newHashMap();
            Matcher matcher = validationPattern.matcher("");
            JsonArray jsonArray = root.getAsJsonArray("emoticons");
            for (int i = 0; i < jsonArray.size(); ++i) {
                int emoteSet;
                JsonObject entry = jsonArray.get(i).getAsJsonObject();
                int n = emoteSet = !entry.has("emoticon_set") || entry.get("emoticon_set").isJsonNull() ? 0 : entry.get("emoticon_set").getAsInt();
                if (emoteSet == 0 || emoteSet == 19194) continue;
                String code = entry.get("code").getAsString();
                matcher.reset(code);
                if (!matcher.matches()) continue;
                String id = entry.get("id").getAsString();
                IEmoteGroup group = groupMap.computeIfAbsent(emoteSet, s -> ChatTweaksAPI.registerEmoteGroup("Twitch-" + s));
                String channel = TwitchEmotesAPI.getChannelForEmoteSet(emoteSet);
                TwitchChannelEmoteData emoteData = new TwitchChannelEmoteData(id, channel);
                IEmote<TwitchChannelEmoteData> emote = ChatTweaksAPI.registerEmote(code, TwitchChannelEmoteSource.INSTANCE, emoteData);
                group.addEmote(emote);
            }
            for (IEmoteGroup group : groupMap.values()) {
                if (group.getEmotes().size() < 5) {
                    EmoteRegistry.discardEmoteGroup(group);
                    continue;
                }
                for (IEmote emote : group.getEmotes()) {
                    TwitchEmotesAPI.registerTwitchEmote(((TwitchChannelEmoteData)emote.getCustomData()).getId(), emote);
                }
            }
        }
    }
}

