/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.chat.emotes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.chat.emotes.Emote;
import net.blay09.mods.chattweaks.chat.emotes.EmoteGroup;
import net.blay09.mods.chattweaks.chat.emotes.IEmote;
import net.blay09.mods.chattweaks.chat.emotes.IEmoteGroup;
import net.blay09.mods.chattweaks.chat.emotes.IEmoteSource;
import net.blay09.mods.chattweaks.event.ReloadEmotes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EmoteRegistry {
    private static final Map<String, IEmoteGroup> groupMap = Maps.newHashMap();
    private static final Map<String, IEmote> emoteMap = Maps.newHashMap();
    private static final List<String> commonEmoteCodes = Lists.newArrayList();
    private static final List<IEmote> disposalList = Lists.newArrayList();
    public static boolean isLoading;

    public static <T> IEmote<T> registerEmote(String name, IEmoteSource<T> source, T data) {
        Emote<T> emote = new Emote<T>(name, source, data);
        emoteMap.put(emote.getCode(), emote);
        if (source.isCommonEmote(emote)) {
            commonEmoteCodes.add(name);
        }
        return emote;
    }

    public static IEmoteGroup registerEmoteGroup(String name) {
        EmoteGroup group = new EmoteGroup(name);
        groupMap.put(name, group);
        return group;
    }

    public static void discardEmoteGroup(IEmoteGroup group) {
        for (IEmote emote : group.getEmotes()) {
            emoteMap.remove(emote.getCode());
            commonEmoteCodes.remove(emote.getCode());
        }
        groupMap.remove(group.getName());
    }

    @Nullable
    public static IEmoteGroup getFirstGroup() {
        if (isLoading) {
            return null;
        }
        return groupMap.values().iterator().next();
    }

    @Nullable
    public static IEmoteGroup getGroup(String name) {
        if (isLoading) {
            return null;
        }
        return groupMap.get(name);
    }

    @Nullable
    public static IEmote fromName(String name) {
        if (isLoading) {
            return null;
        }
        return emoteMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadEmoticons() {
        List<IEmote> list = disposalList;
        synchronized (list) {
            disposalList.addAll(emoteMap.values());
        }
        emoteMap.clear();
        MinecraftForge.EVENT_BUS.post((Event)new ReloadEmotes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runDisposal() {
        List<IEmote> list = disposalList;
        synchronized (list) {
            if (!disposalList.isEmpty()) {
                for (IEmote emote : disposalList) {
                    emote.getImage().disposeTexture();
                }
                disposalList.clear();
            }
        }
    }

    public static Collection<String> getCommonEmoteCodes() {
        if (isLoading) {
            return Collections.emptyList();
        }
        return commonEmoteCodes;
    }

    public static Collection<String> getEmoteCodes() {
        if (isLoading) {
            return Collections.emptyList();
        }
        return emoteMap.keySet();
    }

    public static Collection<IEmote> getEmotes() {
        if (isLoading) {
            return Collections.emptyList();
        }
        return emoteMap.values();
    }

    public static Collection<IEmote> getEmotesByGroup(String group) {
        if (isLoading) {
            return Collections.emptyList();
        }
        IEmoteGroup emoteGroup = groupMap.get(group);
        if (emoteGroup != null) {
            return emoteGroup.getEmotes();
        }
        return Collections.emptyList();
    }

    public static boolean hasGroup(String group) {
        if (isLoading) {
            return false;
        }
        return groupMap.containsKey(group);
    }
}

