/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.chat.emotes;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.chat.emotes.AsyncEmoteLoader;
import net.blay09.mods.chattweaks.chat.emotes.IEmote;
import net.blay09.mods.chattweaks.chat.emotes.IEmoteSource;
import net.blay09.mods.chattweaks.image.renderable.IChatRenderable;
import net.blay09.mods.chattweaks.image.renderable.NullRenderable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class Emote<T>
implements IEmote<T> {
    private final String code;
    private final IEmoteSource<T> source;
    private final T customData;
    private IChatRenderable image = NullRenderable.INSTANCE;
    private boolean loadRequested;

    public Emote(String code, IEmoteSource<T> source, T customData) {
        this.code = code;
        this.source = source;
        this.customData = customData;
    }

    @Override
    public T getCustomData() {
        return this.customData;
    }

    @Override
    public List<String> getTooltip() {
        String mainTooltip = TextFormatting.YELLOW + I18n.func_135052_a((String)"chattweaks:gui.chat.tooltipEmote", (Object[])new Object[0]) + " " + TextFormatting.WHITE + this.code;
        return Lists.newArrayList((Object[])new String[]{mainTooltip, this.source.getTooltip(this.customData)});
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public IEmoteSource<T> getSource() {
        return this.source;
    }

    @Override
    public IChatRenderable getImage() {
        return this.image;
    }

    @Override
    public void setImage(@Nullable IChatRenderable image) {
        if (image == null) {
            image = NullRenderable.INSTANCE;
        }
        this.image = image;
        this.loadRequested = false;
    }

    @Override
    public int getWidthInSpaces() {
        return this.image != null ? this.image.getWidthInSpaces() : 4;
    }

    @Override
    public void requestLoad() {
        if (!this.loadRequested) {
            this.loadRequested = true;
            AsyncEmoteLoader.getInstance().loadAsync(this);
        }
    }

    @Override
    public File getImageCacheFile() {
        return new File(Minecraft.func_71410_x().field_71412_D, "ChatTweaks/cache/" + this.source.getCacheFileName(this.customData));
    }
}

