/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.chat.emotes;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.chat.emotes.IEmote;

public class AsyncEmoteLoader
implements Runnable {
    private static final AsyncEmoteLoader instance = new AsyncEmoteLoader();
    private final LinkedList<IEmote> loadQueue = Lists.newLinkedList();
    private boolean running = true;

    public static AsyncEmoteLoader getInstance() {
        return instance;
    }

    public AsyncEmoteLoader() {
        Thread thread = new Thread((Runnable)this, "EmoteLoader");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAsync(IEmote emote) {
        LinkedList<IEmote> linkedList = this.loadQueue;
        synchronized (linkedList) {
            this.loadQueue.push(emote);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                LinkedList<IEmote> linkedList = this.loadQueue;
                synchronized (linkedList) {
                    int i = 0;
                    while (!this.loadQueue.isEmpty() && ++i <= 5) {
                        IEmote emote = this.loadQueue.pop();
                        try {
                            this.loadEmote(emote);
                        }
                        catch (Exception e) {
                            ChatTweaks.logger.error("Failed to load emote {}: ", (Object)emote.getCode(), (Object)e);
                        }
                    }
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private <T> void loadEmote(IEmote<T> emote) throws Exception {
        emote.getSource().loadEmoteImage(emote);
    }
}

