/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.chat;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.ChatManager;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.ChatTweaksConfig;
import net.blay09.mods.chattweaks.chat.ChatChannel;
import net.blay09.mods.chattweaks.chat.ChatMessage;
import net.blay09.mods.chattweaks.chat.MessageStyle;
import net.blay09.mods.chattweaks.chat.emotes.EmoteScanner;
import net.blay09.mods.chattweaks.chat.emotes.PositionedEmote;
import net.blay09.mods.chattweaks.image.ChatImageEmote;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ChatView {
    public static final Pattern defaultFilterPattern = Pattern.compile("(?:<(?<s>[^>]+)>)? ?(?<m>.*)", 32);
    public static final Pattern groupPattern = Pattern.compile("\\$(?:([0-9])|\\{([\\w])\\})");
    public static final Pattern outputFormattingPattern = Pattern.compile("(\\\\~|~[0-9abcdefkolmnr])");
    private static final EmoteScanner emoteScanner = new EmoteScanner();
    private String name;
    private final List<ChatChannel> channels = Lists.newArrayList();
    private String filterPattern = "";
    private String outputFormat = "$0";
    private MessageStyle messageStyle = MessageStyle.Chat;
    private String outgoingPrefix;
    private boolean isExclusive;
    private boolean isMuted;
    private Pattern compiledFilterPattern = defaultFilterPattern;
    private String builtOutputFormat = this.outputFormat;
    private final List<ChatMessage> chatLines = Lists.newArrayList();
    private boolean hasUnread;
    private boolean isTemporary;

    public ChatView(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static ChatView fromJson(JsonObject jsonView) {
        ChatView view = new ChatView(jsonView.get("name").getAsString());
        view.setFilterPattern(jsonView.has("filterPattern") ? jsonView.get("filterPattern").getAsString() : "");
        view.setOutputFormat(jsonView.get("outputFormat").getAsString());
        view.setMessageStyle(MessageStyle.valueOf(jsonView.get("style").getAsString()));
        view.setOutgoingPrefix(jsonView.has("outgoingPrefix") ? jsonView.get("outgoingPrefix").getAsString() : null);
        view.setExclusive(jsonView.get("isExclusive").getAsBoolean());
        view.setMuted(jsonView.get("isMuted").getAsBoolean());
        JsonArray channels = jsonView.getAsJsonArray("channels");
        if (channels != null) {
            for (int i = 0; i < channels.size(); ++i) {
                JsonElement element = channels.get(i);
                if (!element.isJsonPrimitive()) continue;
                ChatChannel channel = ChatManager.getChatChannel(element.getAsString());
                if (channel != null) {
                    view.addChannel(channel);
                    continue;
                }
                ChatTweaks.logger.error("Channel {} does no longer exist. Removing it from view {}.", (Object)element.getAsString(), (Object)view.name);
            }
        }
        return view;
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("name", this.name);
        object.addProperty("filterPattern", this.filterPattern);
        object.addProperty("outputFormat", this.outputFormat);
        object.addProperty("style", this.messageStyle.name());
        object.addProperty("outgoingPrefix", this.outgoingPrefix);
        object.addProperty("isExclusive", Boolean.valueOf(this.isExclusive));
        object.addProperty("isMuted", Boolean.valueOf(this.isMuted));
        JsonArray channels = new JsonArray();
        for (ChatChannel channel : this.channels) {
            channels.add((JsonElement)new JsonPrimitive(channel.getName()));
        }
        object.add("channels", (JsonElement)channels);
        return object;
    }

    public boolean messageMatches(String message) {
        Matcher matcher = this.compiledFilterPattern.matcher(message);
        return matcher.matches();
    }

    private ITextComponent subTextComponent(ITextComponent component, int startIndex, int endIndex) {
        int index = 0;
        TextComponentString result = new TextComponentString("");
        for (ITextComponent part : component) {
            String sub;
            String unformatted = part.func_150261_e();
            int min = Math.max(0, startIndex - index);
            int max = Math.min(endIndex - index, unformatted.length());
            if (unformatted.length() >= min && max > min && (sub = unformatted.substring(min, max)).length() > 0) {
                TextComponentString sibling = new TextComponentString(sub);
                sibling.func_150255_a(part.func_150256_b());
                result.func_150257_a((ITextComponent)sibling);
            }
            index += unformatted.length();
        }
        return result;
    }

    public ChatMessage addChatLine(ChatMessage chatLine) {
        Matcher matcher;
        block32: {
            chatLine = chatLine.copy();
            this.chatLines.add(chatLine);
            if (this.chatLines.size() > 100) {
                this.chatLines.remove(0);
            }
            if (!(matcher = this.compiledFilterPattern.matcher(chatLine.getTextComponent().func_150260_c())).matches()) {
                return chatLine;
            }
            try {
                if (chatLine.getSender() == null) {
                    chatLine.setSender(this.subTextComponent(chatLine.getTextComponent(), matcher.start("s"), matcher.end("s")));
                }
                if (chatLine.getMessage() == null) {
                    chatLine.setMessage(this.subTextComponent(chatLine.getTextComponent(), matcher.start("m"), matcher.end("m")));
                }
            }
            catch (IllegalArgumentException ignored) {
                if (chatLine.getMessage() != null) break block32;
                chatLine.setMessage(chatLine.getTextComponent());
            }
        }
        ITextComponent source = chatLine.getTextComponent();
        ITextComponent textComponent = chatLine.getTextComponent();
        if (!this.builtOutputFormat.equals("$0")) {
            textComponent = new TextComponentString("");
            int last = 0;
            Matcher outputMatcher = groupPattern.matcher(this.builtOutputFormat);
            while (outputMatcher.find()) {
                if (outputMatcher.start() > last) {
                    textComponent.func_150258_a(this.builtOutputFormat.substring(last, outputMatcher.start()));
                }
                ITextComponent groupValue = null;
                String namedGroup = outputMatcher.group(2);
                if (namedGroup != null) {
                    if (namedGroup.equals("s") && chatLine.getSender() != null) {
                        groupValue = chatLine.getSender();
                    } else if (namedGroup.equals("m") && chatLine.getMessage() != null) {
                        groupValue = chatLine.getMessage();
                    } else if (namedGroup.equals("t")) {
                        groupValue = new TextComponentString(ChatTweaksConfig.timestampFormat.format(new Date(chatLine.getTimestamp())));
                        groupValue.func_150256_b().func_150238_a(TextFormatting.GRAY);
                    } else {
                        int groupStart = -1;
                        int groupEnd = -1;
                        try {
                            groupStart = matcher.start(namedGroup);
                            groupEnd = matcher.end(namedGroup);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        groupValue = groupStart != -1 && groupEnd != -1 ? this.subTextComponent(source, groupStart, groupEnd) : chatLine.getOutputVar(namedGroup);
                    }
                } else {
                    int group = Integer.parseInt(outputMatcher.group(1));
                    if (group >= 0 && group <= matcher.groupCount()) {
                        groupValue = this.subTextComponent(source, matcher.start(group), matcher.end(group));
                    }
                }
                if (groupValue == null) {
                    groupValue = new TextComponentString("*");
                }
                last = outputMatcher.end();
                textComponent.func_150257_a(groupValue);
            }
            if (last < this.builtOutputFormat.length()) {
                textComponent.func_150258_a(this.builtOutputFormat.substring(last));
            }
        }
        ITextComponent newComponent = null;
        for (ITextComponent component : textComponent) {
            String text;
            String resultText = text = component.func_150261_e();
            if (text.length() > 1 && component instanceof TextComponentString) {
                int index = 0;
                StringBuilder sb = new StringBuilder();
                List<PositionedEmote> emotes = emoteScanner.scanForEmotes(text, null);
                for (PositionedEmote emoteData : emotes) {
                    if (index < emoteData.getStart()) {
                        sb.append(text, index, emoteData.getStart());
                    }
                    int imageIndex = sb.length() + 1;
                    sb.append("\u00a7*");
                    for (int i = 0; i < emoteData.getEmote().getWidthInSpaces(); ++i) {
                        sb.append(' ');
                    }
                    chatLine.addImage(new ChatImageEmote(imageIndex, emoteData.getEmote()));
                    index = emoteData.getEnd() + 1;
                }
                if (index < text.length()) {
                    sb.append(text.substring(index));
                }
                resultText = sb.toString();
            }
            if (text.length() <= 0) continue;
            if (newComponent == null) {
                newComponent = new TextComponentString("");
                newComponent.func_150255_a(textComponent.func_150256_b().func_150206_m());
            }
            TextComponentString copyComponent = new TextComponentString(resultText);
            if (newComponent.func_150256_b() == component.func_150256_b()) {
                newComponent.func_150255_a(new Style());
            } else {
                copyComponent.func_150255_a(component.func_150256_b());
            }
            newComponent.func_150257_a((ITextComponent)copyComponent);
        }
        if (newComponent == null) {
            newComponent = textComponent;
        }
        chatLine.setTextComponent(newComponent);
        return chatLine;
    }

    public List<ChatMessage> getChatLines() {
        return this.chatLines;
    }

    public boolean hasUnreadMessages() {
        return this.hasUnread;
    }

    public void markAsUnread(boolean hasUnread) {
        this.hasUnread = hasUnread;
    }

    public void addChannel(ChatChannel channel) {
        this.channels.add(channel);
    }

    public Collection<ChatChannel> getChannels() {
        return this.channels;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
        if (!filterPattern.isEmpty()) {
            try {
                this.compiledFilterPattern = Pattern.compile(filterPattern, 32);
            }
            catch (PatternSyntaxException e) {
                this.compiledFilterPattern = defaultFilterPattern;
            }
        } else {
            this.compiledFilterPattern = defaultFilterPattern;
        }
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
        Matcher matcher = outputFormattingPattern.matcher(outputFormat);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "\u00a7" + matcher.group(1));
        }
        matcher.appendTail(sb);
        this.builtOutputFormat = sb.toString();
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.isExclusive = exclusive;
    }

    public MessageStyle getMessageStyle() {
        return this.messageStyle;
    }

    public void setMessageStyle(MessageStyle messageStyle) {
        this.messageStyle = messageStyle;
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    public void setMuted(boolean isMuted) {
        this.isMuted = isMuted;
    }

    @Nullable
    public String getOutgoingPrefix() {
        return this.outgoingPrefix;
    }

    public void setOutgoingPrefix(@Nullable String outgoingPrefix) {
        this.outgoingPrefix = outgoingPrefix;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setTemporary(boolean temporary) {
        this.isTemporary = temporary;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatView chatView = (ChatView)o;
        return this.name.equals(chatView.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void refresh() {
        this.chatLines.clear();
        this.channels.stream().flatMap(it -> it.getChatMessages().stream()).filter(it -> this.messageMatches(it.getTextComponent().func_150260_c())).sorted(Comparator.comparingInt(ChatMessage::getId).reversed()).limit(100L).sorted(Comparator.comparingInt(ChatMessage::getId)).forEach(this::addChatLine);
    }
}

