/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.chat;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.chat.ChatView;
import net.blay09.mods.chattweaks.image.ChatImage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;

public class ChatMessage {
    private final int id;
    private ITextComponent chatComponent;
    private int backgroundColor;
    private List<ChatImage> images;
    private int[] rgbColors;
    private NBTTagCompound customData;
    private long timestamp;
    private ChatView exclusiveView;
    private ITextComponent sender;
    private ITextComponent message;
    private Map<String, ITextComponent> outputVars;

    public ChatMessage(int id, ITextComponent chatComponent) {
        this.id = id;
        this.chatComponent = chatComponent;
        this.timestamp = System.currentTimeMillis();
    }

    public int getId() {
        return this.id;
    }

    public ITextComponent getTextComponent() {
        return this.chatComponent;
    }

    public void setTextComponent(ITextComponent chatComponent) {
        this.chatComponent = chatComponent;
    }

    public NBTTagCompound getCustomData() {
        return this.customData;
    }

    public boolean hasData() {
        return this.customData != null;
    }

    public boolean hasBackgroundColor() {
        return this.backgroundColor != 0;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Nullable
    public List<ChatImage> getImages() {
        return this.images;
    }

    @Nullable
    public ChatImage getImage(int index) {
        if (this.images == null || index < 0 || index >= this.images.size()) {
            return null;
        }
        return this.images.get(index);
    }

    public ChatMessage addImage(ChatImage image) {
        if (this.images == null) {
            this.images = Lists.newArrayList((Object[])new ChatImage[]{image});
        } else {
            this.images.add(image);
        }
        return this;
    }

    public ChatMessage withRGB(int count) {
        this.rgbColors = new int[count];
        for (int i = 0; i < this.rgbColors.length; ++i) {
            this.rgbColors[i] = 0xFFFFFF;
        }
        return this;
    }

    public ChatMessage setRGBColor(int index, int color) {
        if (index >= 0 && index < this.rgbColors.length) {
            this.rgbColors[index] = color;
        }
        return this;
    }

    public int getRGBColor(int index) {
        if (this.rgbColors == null || index < 0 || index >= this.rgbColors.length) {
            return 0xFFFFFF;
        }
        return this.rgbColors[index];
    }

    public boolean hasRGBColors() {
        return this.rgbColors != null;
    }

    public boolean hasImages() {
        return this.images != null;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void clearImages() {
        this.images = null;
    }

    public ChatMessage copy() {
        ChatMessage out = new ChatMessage(this.id, this.chatComponent);
        out.backgroundColor = this.backgroundColor;
        if (this.images != null) {
            out.images = this.images;
        }
        out.rgbColors = this.rgbColors;
        out.outputVars = this.outputVars;
        if (this.customData != null) {
            out.customData = this.customData.func_74737_b();
        }
        out.timestamp = this.timestamp;
        out.sender = this.sender;
        out.message = this.message;
        return out;
    }

    public void setExclusiveView(ChatView view) {
        this.exclusiveView = view;
    }

    public boolean hasExclusiveView() {
        return this.exclusiveView != null;
    }

    public ChatView getExclusiveView() {
        return this.exclusiveView;
    }

    public void setSender(@Nullable ITextComponent sender) {
        this.sender = sender;
    }

    @Nullable
    public ITextComponent getSender() {
        return this.sender;
    }

    @Nullable
    public ITextComponent getMessage() {
        return this.message;
    }

    public void setMessage(ITextComponent message) {
        this.message = message;
    }

    public void setOutputVar(String key, @Nullable ITextComponent value) {
        if (this.outputVars == null) {
            this.outputVars = Maps.newHashMap();
        }
        this.outputVars.put(key, value);
    }

    @Nullable
    public ITextComponent getOutputVar(String key) {
        return this.outputVars != null ? this.outputVars.get(key) : null;
    }

    public String toString() {
        return this.chatComponent.func_150260_c();
    }
}

