/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.chat;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.blay09.mods.chattweaks.chat.ChatMessage;
import net.minecraft.util.ResourceLocation;

public class ChatChannel {
    private final Map<Integer, ChatMessage> chatMessages = Maps.newHashMap();
    private final String name;
    private final ResourceLocation icon;
    private final String description;
    private boolean enabled;

    public ChatChannel(String name, String description, ResourceLocation icon) {
        this.name = name;
        this.description = description;
        this.icon = icon;
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void addChatMessage(ChatMessage chatMessage) {
        this.chatMessages.put(chatMessage.getId(), chatMessage);
    }

    public void removeChatMessage(int chatMessageId) {
        this.chatMessages.remove(chatMessageId);
    }

    public Collection<ChatMessage> getChatMessages() {
        return this.chatMessages.values();
    }

    public void clearChatMessages() {
        this.chatMessages.clear();
    }
}

