/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.balyware;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.minecraft.client.Minecraft;

public class CachedAPI {
    private static final Gson gson = new Gson();
    private static final long DEFAULT_CACHE_TIME = 86400000L;

    @Nullable
    public static JsonObject loadCachedAPI(String url, String fileName, @Nullable String accept) {
        return CachedAPI.loadCachedAPI(url, fileName, 86400000L, accept);
    }

    @Nullable
    public static JsonObject loadCachedAPI(String url, String fileName, long maxCacheTime, @Nullable String accept) {
        return CachedAPI.loadCachedAPI(url, new File(CachedAPI.getCacheDirectory(), fileName), maxCacheTime, accept);
    }

    @Nullable
    public static JsonObject loadCachedAPI(String url, File cacheFile, long maxCacheTime, @Nullable String accept) {
        JsonObject result = CachedAPI.loadLocal(cacheFile, false, maxCacheTime);
        if (result == null) {
            result = CachedAPI.loadRemote(url, accept);
            if (result == null) {
                result = CachedAPI.loadLocal(cacheFile, true, maxCacheTime);
            } else {
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(cacheFile));){
                    gson.toJson((JsonElement)result, (Appendable)writer);
                }
                catch (IOException e) {
                    ChatTweaks.logger.error("An error occurred trying to cache an API result: ", (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static JsonObject loadLocal(File file, boolean force, long maxCacheTime) {
        if (!file.exists()) return null;
        if (!force) {
            if (System.currentTimeMillis() - file.lastModified() >= maxCacheTime) return null;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            return jsonObject;
        }
        catch (IOException e) {
            ChatTweaks.logger.error("An error occurred trying to load a cached API result: ", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static JsonObject loadRemote(String url, @Nullable String accept) {
        try {
            URL apiURL = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)apiURL.openConnection();
            if (accept != null) {
                connection.setRequestProperty("Accept", accept);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                return jsonObject;
            }
            catch (Exception e) {
                ChatTweaks.logger.error("An error occurred trying to parse a JSON API result: ", (Throwable)e);
                return null;
            }
        }
        catch (IOException e) {
            ChatTweaks.logger.error("An error occurred trying to load from an API: ", (Throwable)e);
            return null;
        }
    }

    public static File getCacheDirectory() {
        File file = new File(Minecraft.func_71410_x().field_71412_D, "ChatTweaks/cache/");
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Could not create cache directory for Chat Tweaks.");
        }
        return file;
    }
}

