/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks.auth;

import com.google.common.collect.Maps;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.auth.TokenPair;

public class AuthManager {
    private final Map<String, TokenPair> tokenMap = Maps.newHashMap();

    public TokenPair getToken(String id) {
        return this.tokenMap.get(id);
    }

    public void storeToken(String id, String username, String token, boolean doNotSave) {
        this.tokenMap.put(id, new TokenPair(username, token, doNotSave));
        this.save();
    }

    public void load() {
        File userHome = new File(System.getProperty("user.home"));
        try (DataInputStream in2 = new DataInputStream(new FileInputStream(new File(userHome, ".chattweaks-auth.dat")));){
            int count = in2.readByte();
            for (int i = 0; i < count; ++i) {
                this.storeToken(in2.readUTF(), in2.readUTF(), in2.readUTF(), false);
            }
        }
        catch (FileNotFoundException in2) {
        }
        catch (IOException e) {
            ChatTweaks.logger.error("An error occurred when trying to load authentication data: ", (Throwable)e);
        }
    }

    private void save() {
        File userHome = new File(System.getProperty("user.home"));
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(userHome, ".chattweaks-auth.dat")));){
            List list = this.tokenMap.entrySet().stream().filter(p -> !((TokenPair)p.getValue()).isDoNotStore()).collect(Collectors.toList());
            out.writeByte(list.size());
            for (Map.Entry entry : list) {
                out.writeUTF((String)entry.getKey());
                out.writeUTF(((TokenPair)entry.getValue()).getUsername());
                out.writeUTF(((TokenPair)entry.getValue()).getToken());
            }
        }
        catch (IOException e) {
            ChatTweaks.logger.error("An error occurred when trying to save authentication data: ", (Throwable)e);
        }
    }
}

